#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
source $(dirname ${cur_dir})/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

# ================================= install ====================================
function install()
{
    which docker > /dev/null 2>&1
    if [ $? -eq 0 ];then
        docker_version=`docker info |grep "Server Version" | awk '{print $3}'`
        log_info "Docker version now is ${docker_version}."
        return
    fi

    rm -rf /opt/huawei/dj-docker > /dev/null 2>&1
    mkdir -p /opt/huawei/dj-docker > /dev/null 2>&1
    CHECK_RESULT $? "Create docker engine directory dj-docker failed."

    rm -rf /var/lib/docker && ln -sf /opt/huawei/dj-docker /var/lib/docker
    CHECK_RESULT $? "Create soft link for docker engine directory failed."

    rpm -Uivh --force --nodeps  $(dirname ${cur_dir})/repo/platform/euler/docker/lib*.rpm
    CHECK_RESULT $? "Install docker depend lib failed."

    rpm -Uivh --force --nodeps  $(dirname ${cur_dir})/repo/platform/euler/docker/docker-engine*.rpm
    CHECK_RESULT $? "Install docker failed."
    # safe enforce
    sed -i 's/^OPTIONS.*/OPTIONS="--config-file= --live-restore"/g'  /etc/sysconfig/docker
    log_info "Install docker successfully."
}

# ================================= check ======================================
function check()
{
    log_info "Start to check whether docker has been installed."
    docker ps > /dev/null 2>&1
    if [ $? -eq 0 ];then
        docker_version=`docker info |grep "Server Version" | awk '{print $3}'`
        log_info "Docker version now is ${docker_version}."
    else
        log_error "Install docker failed."
        exit 1
    fi
    log_info "Docker has been installed successfully."
}

# ================================= rollback ===================================
function rollback()
{
    docker=`rpm -qa |grep docker`
    docker_count = `echo ${docker} | awk -F' ' '{print NF}'`
    until [ ${docker_count} -le 0 ]
    do
        sub_docker=`echo ${docker} | awk -F' ' '{print $(echo "'"${docker_count}"'")}'`
        rpm -e --nodeps ${sub_docker}
        CHECK_RESULT $? "Uninstall rpm ${sub_docker} failed."
        docker_count=$(( ${docker_count} - 1 ))
    done
    if [ -L "/var/lib/docker/dj-docker" ]; then
        rm -rf  /var/lib/docker
        CHECK_RESULT $? "Remove soft link for docker engine directory failed."
    fi
    if [ -d "/opt/huawei/dj-docker" ]; then
        rm -rf /opt/huawei/dj-docker
        CHECK_RESULT $? "Remove docker engine directory dj-docker failed."
    fi
    log_info "Rollback docker successfully."
}

# ================================= main =======================================
main()
{
    if [ $# -ne 1 ]; then
        log_error "Parameter error. Usage: bash docker.sh [install|check|rollback]."
        exit 1
    fi

    case "$1" in
        install)
            install
        ;;
        check)
            check
        ;;
        rollback)
            rollback
        ;;
        *)
            log_error "Parameter error. Usage: bash docker.sh [install|check|rollback]."
            exit 1
        ;;
    esac
}

main "$@"
exit 0