#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
source $(dirname ${cur_dir})/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

function _modify_umask()
{
    if [ -f "/etc/login.defs" ];then
        sed -i "/UMASK/ c UMASK    027"  /etc/login.defs
    fi

    if [ -f "/root/.bash_profile" ];then
        sed -i "/umask/ c umask    027"  /root/.bash_profile
    fi

    if [ -f "/etc/bashrc" ];then
        sed -i "/umask 0077/ c umask 0027"  /etc/bashrc
    fi
    source /etc/bashrc

    log_info "OS_config, _modify_umask OK."
}

# ================================= install ====================================
function install()
{
    log_info "Start to config OS."

    bash ${cur_dir}/allocate_disk.sh
    CHECK_RESULT $? "Allocate disk failed."

    # config umask
    _modify_umask

    # stop and disable firewall
    systemctl stop firewalld
    systemctl disable firewalld.service
    rm -rf /etc/sysconfig/iptables
    systemctl restart iptables

    # restart docker service
    systemctl restart docker.service

    # restart rpcbind service
    systemctl restart rpcbind.service

    #stop rpcbind
    service rpcbind stop
    systemctl disable  rpcbind

    # stop rpcbind.socket
    systemctl stop rpcbind.socket
    systemctl disable rpcbind.socket

    log_info "Config OS successfully."
}

# ================================= check ======================================
function check()
{
    # to do
    exit 0
}

# ================================= rollback ===================================
function rollback()
{
    # to do
    exit 0
}

# ================================= main =======================================
main()
{
    if [ $# -lt 1 ]; then
        log_error "Parameter error. Usage: bash os_config.sh [install|check|rollback] <public|private>."
        exit 1
    fi

    case "$1" in
        install)
            install
        ;;
        check)
            check
        ;;
        rollback)
            rollback
        ;;
        *)
            log_error "Parameter error. Usage: bash os_config.sh [install|check|rollback] <public|private>."
            exit 1
        ;;
    esac
}

main "$@"
exit 0