#!/bin/bash
function config_etchosts()
{
    if [[ $# -ne 2 ]];then
        echo "usage:  config_etchosts [hostsname] [ip]"
        exit 1
    fi
    hostsname=$1
    ip=$2
    ret=`cat /etc/hosts | grep ${hostsname} |awk -F' ' '{print $1}'`
    if [[ -z ${ret} || ${ret} != ${ip} ]];then
        sed -i "/${hostsname}/"d /etc/hosts
        sed -i "$a\$ip ${hostsname}" /etc/hosts
    fi
}

until [ -z "$1" ]
do
    name=`echo $1 | awk -F':' '{print $1}'`
    ip=`echo $1 | awk -F':' '{print $2}'`
    config_etchosts ${name} ${ip}
    shift
done
exit 0
