#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname ${cur_dir})
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="csbs_install"

# 应用三方补丁
for patch_file in ${LINE_ROOT}/repo/third_party_patchs/*.patch
do
    path=`grep -Po '(?<=\s)/usr/lib/.*py(?=\s)' ${patch_file}`
    patch -p0 -N --dry-run --silent ${path} ${patch_file}
    [[ $? -ne 0 ]] && continue
    patch ${path} ${patch_file}
    CHECK_RESULT $? "patch ${path} failed."
    log_info "patch ${path} success."
done
log_info "Apply thirdparty patch success."

# 通用SHELL脚本
mkdir -p /opt/huawei/dj/inst/bin
/usr/bin/cp -f ${LINE_ROOT}/bin/utils.sh /opt/huawei/dj/inst/bin
CHECK_RESULT $? "Copy utils.sh failed."
log_info "Copy utils.sh success."

# 通用配置
mkdir -p /opt/huawei/dj/{cfg,etc,bin}
/usr/bin/cp -f ${LINE_ROOT}/conf/keylist.ini /opt/huawei/dj/cfg
/usr/bin/cp -f ${LINE_ROOT}/conf/disable_log.para /opt/huawei/dj/cfg
CHECK_RESULT $? "Copy common conf failed."
log_info "Copy common conf success."

# JRE环境安装
jre_dir=$(mktemp -d /tmp/nameXXXXX)
tar -xf ${LINE_ROOT}/repo/platform/java/jre-*.tar.gz -C ${jre_dir}
mkdir -p /opt/huawei/dj/bin/
/usr/bin/mv -f ${jre_dir}/jre* /opt/huawei/dj/bin/jre && rm -rf ${jre_dir}
CHECK_RESULT $? "Install Jre failed."
log_info "Install Jre success."

# 通用Python工具
csbs_python -m pip install --no-deps --force-reinstall  ${LINE_ROOT}/repo/self_developed/basesdk*.whl
CHECK_RESULT $? "Install basesdk failed."
log_info "Install basesdk success."

# 安装数据库驱动
tar --extract --file=${LINE_ROOT}/repo/platform/gaussdb/gaussdb_app.tar.gz app/lib/libpq.so*
CHECK_RESULT $? "Unzip libpq from gaussdb_app failed."
/usr/bin/mv -f app/lib/libpq.so* /usr/lib64 && rm -rf app
CHECK_RESULT $? "Mv libpq to /usr/lib failed."
log_info "Install libpq success."

# 设置通用权限
chown -h root:openstack "/usr/lib/csbs_python/site-packages/setuptools/script (dev).tmpl"
chown -h root:openstack "/usr/lib/csbs_python/site-packages/setuptools/command/launcher manifest.xml"
chown -h root:openstack /usr/lib64/libpq.so*
chmod 550  /usr/lib64/libpq.so*
setprivilege  /usr/lib/csbs_python
setprivilege  /opt/huawei/dj
exit 0