#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

TOOL_PATH=/opt/omm/oma/tools/
VERSION_PATH=/opt/huawei/dj/versions/
LOCK_DIR=${TOOL_PATH}lock

# 部署卸载目录
function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/alarm"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/alarm.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function config_alarm()
{
    mkdir -p /var/log/huawei/dj/services/system/alarm/
    chmod 750 /var/log/huawei /var/log/huawei/dj/services/system/alarm
    chown -h root:openstack /var/log/huawei /var/log/huawei/dj
    chown -h root:openstack /var/log/huawei/dj/services /var/log/huawei/dj/services/system
    chown -h root:openstack /var/log/huawei/dj/services/system/alarm
    local alarm_file="/var/log/huawei/dj/services/system/alarm/oma_alarm.log"
    touch ${alarm_file}
    chmod 640 ${alarm_file}
    chown -h openstack:openstack ${alarm_file}
}

deploy_uninstall_script

mkdir -p ${TOOL_PATH}
/usr/bin/cp  -rf ${CURRENT_PATH}/src/* ${TOOL_PATH}
chmod 750 ${TOOL_PATH}/sendAlarm.sh
rm -f ${TOOL_PATH}/sendAlarm && ln -sf ${TOOL_PATH}/sendAlarm.sh ${TOOL_PATH}/sendAlarm
setprivilege ${TOOL_PATH}

mkdir -p ${VERSION_PATH}
/usr/bin/cp -f ${CURRENT_PATH}/alarm.ver ${VERSION_PATH}
setprivilege ${VERSION_PATH}

mkdir ${LOCK_DIR}
rm -rf ${LOCK_DIR}/*
for idx in {1..30}; do
    touch ${LOCK_DIR}/alarm${idx}.lock
done
touch ${LOCK_DIR}/get_token.lock
setprivilege ${LOCK_DIR}
config_alarm