# -*- coding: UTF-8 -*-
import json
import os
import sys
import six
from basesdk import utils
log = utils.get_logger("alarm")
ALARM_INFO_JSON_FILE = '%s/../config/alarm_info.json' % sys.path[0]


def _(location_info, oc_language):
    if not isinstance(location_info, str):
        raise Exception("location info must is str type")

    if oc_language == 'zh':
        return to_zh(location_info)
    elif oc_language == 'en':
        return to_en(location_info)
    else:
        return location_info


def to_zh(location_info):
    if not location_info.startswith("@"):
        return location_info

    alarm_info = get_alarm_info()
    if not alarm_info:
        log.info("Alarm i18n info not exist")
        return location_info

    location_info_i18n = location_info[1:]
    location_items = location_info_i18n.split(",")
    for location_item in location_items:
        item_name = location_item.split("=")[0].strip()
        if item_name in alarm_info.keys():
            location_info_i18n = location_info_i18n.replace(
                item_name, alarm_info.get(item_name))

    return location_info_i18n


def to_en(location_info):
    if not location_info.startswith("@"):
        return location_info

    return location_info[1:]


def get_alarm_info():
    if not os.path.exists(ALARM_INFO_JSON_FILE):
        return

    with open(ALARM_INFO_JSON_FILE, 'r') as alarm_info_json_file:
        try:
            return json.load(alarm_info_json_file)
        except Exception as err:
            log.error("Load alarm_info.json file content failed, "
                      "error info: %s" % six.text_type(err))


def alarm_i18n(lang_data_dict):
    return "##".join((lang_data_dict["zh_CN"], lang_data_dict["en_US"]))
