import json
from kmc import kmc
from obj import CmsAlarmConfig
from basesdk import cms_info
from basesdk import utils
import pem
import time
import six
import re
import requests
import decimal
ALARM_CONFIG_KEY = "alarm.alarm_config"
ALARM_TOKEN_PREFIX = "alarm.token."

kmc_api = kmc.API()
pem_manager = pem.PemManager()


def get_oc_language(alarm_endpoint):
    try:
        resp = requests.get("https://" + alarm_endpoint,
                            verify=False, timeout=5)
        result = re.search('var currentLocale = "(.*)";', resp.text)
        if result:
            return result.groups()[0]
        return "en_US"
    except Exception:
        return "en_US"


def get_manage_ip():
    return utils.get_haproxy_float_ip()


def get_alarm_config_from_cms():
    config_json = cms_info.get_cms_info(ALARM_CONFIG_KEY)
    config_json = json.loads(config_json)
    endpoint = config_json["endpoint"]
    alarm_type = config_json["type"]
    username = ""
    password = ""
    if "username" in config_json:
        username = config_json["username"]
    if "password" in config_json:
        password = config_json["password"]
        password = kmc_api.decrypt(0, password)
    return CmsAlarmConfig(alarm_type, endpoint, username, password)


def get_oc_token_from_cms():
    try:
        alarm_token_key = "%s%s" % (
            ALARM_TOKEN_PREFIX, utils.get_local_ip().replace(".", ""))
        raw_token = cms_info.get_cms_info(alarm_token_key)
        raw_token = kmc_api.decrypt(0, raw_token)
        words = raw_token.split("|")
        oc_token = words[0]
        timestamp = decimal.Decimal(f"{words[1]}")
        if decimal.Decimal(f"{time.time()}") - timestamp > decimal.Decimal("300"):
            return None
        return oc_token
    except Exception:
        return None


def put_oc_token_to_cms(oc_token, expire=False):
    alarm_token_key = "%s%s" % (
        ALARM_TOKEN_PREFIX, utils.get_local_ip().replace(".", ""))
    if not expire:
        alarm_token_value = "%s|%s" % (oc_token, six.text_type(time.time()))
    else:
        alarm_token_value = "%s|%s" % (oc_token, six.text_type(0))
    value = kmc_api.encrypt(0, alarm_token_value)
    ret = cms_info.put_cms_info(alarm_token_key, value)
    if ret != 0:
        raise Exception("ERROR: cms PUT return %d" % ret)


def expire_token(oc_token):
    put_oc_token_to_cms(oc_token, True)


# for test
if __name__ == "__main__":
    alarm_config = get_alarm_config_from_cms()
    print(alarm_config.endpoint)
