import json
import requests


def get_token(endpoint, user_id, password, host_ip):
    url = "https://" + endpoint + "/oc/v2.3/tokens"
    headers = {"Content-Type": "application/json;charset=UTF-8",
               "Accept": "application/json"}
    param = {"user_id": user_id,
             "value": password,
             "host_ip": host_ip}
    data = json.dumps(param, encoding="UTF-8", ensure_ascii=False)
    kwargs = {
        "headers": headers,
        "data": data,
        "verify": False
    }

    resp = requests.post(url, timeout=60, **kwargs)
    if resp.status_code == 200:
        result = resp.text
        token_json = json.loads(result)
        token = token_json["data"]
    else:
        raise Exception("ERROR: get oc token from v2.3 fail, code=%d, msg: %s"
                        % (resp.status_code, resp.text))

    return token


def get_token_from_60(endpoint, user_id, password, host_ip):
    url = "https://" + endpoint + "/v6.0/auth/tokens"
    headers = {"Content-Type": "application/json;charset=UTF-8",
               "Accept": "application/json"}
    param = {"userId": user_id,
             "value": password,
             "hostIp": host_ip}
    data = json.dumps(param, encoding="UTF-8", ensure_ascii=False)
    kwargs = {
        "headers": headers,
        "data": data,
        "verify": False
    }

    resp = requests.post(url, timeout=60, **kwargs)
    if resp.status_code == 200:
        result = resp.text
        token_json = json.loads(result)
        token = token_json["data"]
    else:
        raise Exception("ERROR: get oc token from v6.0 fail, code=%d, msg: %s"
                        % (resp.status_code, resp.text))

    return token


def send_alarm_to_23(endpoint, data, token):
    url = "https://" + endpoint + "/oc/v2.3/alarm/thirdalarms"
    headers = {"Content-Type": "application/json;charset=UTF-8",
               "Accept": "application/json",
               "X-Auth-Token": token}
    param = {"data": data}
    data_json = json.dumps(param, encoding="UTF-8",
                           ensure_ascii=False).encode("utf-8")
    kwargs = {
        "headers": headers,
        "data": data_json,
        "verify": False
    }

    resp = requests.post(url, timeout=60, **kwargs)
    if resp.status_code != 200:
        raise Exception("ERROR: send alarm to oc 2.3 fail, code=%d, msg: %s"
                        % (resp.status_code, resp.text))


def send_alarm_to_30(endpoint, data, token):
    url = "https://" + endpoint + "/rest/csfault/v1/alarms"
    headers = {"Content-Type": "application/json;charset=UTF-8",
               "Accept": "application/json",
               "X-Auth-Token": token}
    param = {"alarmRecords": [data]}
    data_json = json.dumps(param, encoding="UTF-8",
                           ensure_ascii=False).encode("utf-8")
    kwargs = {
        "headers": headers,
        "data": data_json,
        "verify": False
    }

    resp = requests.put(url, timeout=60, **kwargs)
    if resp.status_code != 200:
        raise Exception("ERROR: send alarm to oc 3.0 fail, code=%d, msg: %s"
                        % (resp.status_code, resp.text))


def send_alarm_to_60(endpoint, data, token, service_host):
    url = "https://" + endpoint + "/rest/csfault/v1/alarms"
    headers = {"Content-Type": "application/json;charset=UTF-8",
               "Accept": "application/json",
               "X-Auth-Token": token,
               "service-host": service_host}
    param = {"alarmRecords": [data]}
    data_json = json.dumps(param, encoding="UTF-8",
                           ensure_ascii=False).encode("utf-8")
    kwargs = {
        "headers": headers,
        "data": data_json,
        "verify": False
    }

    resp = requests.put(url, timeout=60, **kwargs)
    if resp.status_code != 200:
        raise Exception("ERROR: send alarm to oc 6.0 fail, code=%d, msg: %s"
                        % (resp.status_code, resp.text))
