#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/alarm_upgrade.log"
CUR_NODE_IDX=$(get_info.py node_index)
##########################################
#
#check upgrade version
#
##########################################


function check_version()
{
    is_need_upgrade alarm;ret_val=$?
    if [ ${ret_val} -eq 1 ]; then
        echo -1
        exit 0
    fi
}

function is_now_upgrade()
{
    local TARGET_DIR=/opt/omm/oma/tools/
    local PROFILE=`get_info.py profile`
    if [ "${PROFILE}" != "public" ]; then
        return;
    fi
    ls -la ${TARGET_DIR}/sendAlarm | grep sendAlarm_omm_agent.sh; omm_agent_result=$?
    ls -la ${TARGET_DIR}/sendAlarm | grep sendAlarm.sh; alarm_result=$?
    if [ ${omm_agent_result} -eq 1 -a ${alarm_result} -eq 1 ]; then
        log_info "Not upgrade alarm before switch to new alarm tool."
        echo -1
        exit 0
    fi
}

function check_rollback()
{
    should_rollback read alarm
    if [ $? -ne 0 ];then
        echo "-1"
        log_info "do not need rollback"
        exit 0
    fi
}

if [[ $1 != "rollback" ]] && [[ $1 != "upgrade" ]];then
    echo "-1"
    exit 0
fi
if [[ $1 == "upgrade" ]];then
    check_version
    is_now_upgrade
fi
if [[ $1 == "rollback" ]];then
    check_rollback
fi
echo "${CUR_NODE_IDX}"

