#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/alarm_upgrade.log"

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CUR_DIR}/upgrade_files.conf
    if [ $? -ne 0 ]; then
        log_error "Rollback alarm failed."
        return 1
    fi
    log_info "Rollback alarm success."
    return 0
}

function main()
{
    log_info "Begin to rollback alarm..."
    rm -rf /opt/huawei/dj/inst/services/alarm
    rm -rf /opt/huawei/dj/versions/alarm.ver
    rollback_files; CHECK_RESULT $?
}

main
sed -i '/^alarm$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback alarm success."
exit 0
