#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/alarm_upgrade.log"
TARGET_DIR=/opt/omm/oma/tools/

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]]; then
        log_error "backup alarm failed."
        return 1
    fi
    log_info "backup alarm success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write alarm
    if [[ $? -ne 0 ]];then
        log_error "failed to write alarm upgrade flag."
        return 1
    fi
    log_info "success to write alarm upgrade flag."
    return 0
}

function upgrade()
{
    sh $(dirname ${CURRENT_DIR})/uninstall.sh
    sh $(dirname ${CURRENT_DIR})/install.sh
}

function switch_to_oma_script()
{
    if [[ ${omm_agent_result} -eq 0 ]]; then
        rm -f ${TARGET_DIR}/sendAlarm && ln -s ${TARGET_DIR}/sendAlarm_omm_agent.sh ${TARGET_DIR}/sendAlarm
        chown -h root:openstack ${TARGET_DIR}/ -R
        setprivilege ${TARGET_DIR}
        chmod 750 ${TARGET_DIR}/sendAlarm_omm_agent.sh
        chmod 750 ${TARGET_DIR}/sendAlarm.sh
    fi
}

function main()
{
    ls -la ${TARGET_DIR}/sendAlarm | grep sendAlarm_omm_agent.sh; omm_agent_result=$?
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    upgrade; CHECK_RESULT $?
    switch_to_oma_script; CHECK_RESULT $?
}

log_info "alarm upgrade start"
main
log_info "install new alarm service done"
exit 0
