#! /bin/bash
BACKUP_PATH="$1"
if [[ "${BACKUP_PATH}" != "/opt/djbackup/db/manualbk" ]] && [[ "${BACKUP_PATH}" != "/opt/djbackup/db" ]];then
    exit 1
fi
HOME_DIR='/opt/huawei/dj/bin/backup/backup'
source ${HOME_DIR}/gaussdb_backup_base.sh

#check directory and db state before backup
function prebackup()
{
    runlog "INFO | begin to prebackup."
    db_state=`docker exec gaussdb /opt/gaussdb/app/bin/gs_ctl -D /opt/fusionplatform/data/gaussdb query | grep DB_STATE | awk -F : '{print $2}' | awk '{gsub(/ /,"")}1'`
    runlog "INFO | db state is ${db_state}"
    if [[ ${db_sate} -ne "Normal" ]];then
        runlog "ERROR | gaussdb is not run."
        exit 1
    fi
    runlog "INFO | prebackup succeed."
}

#execute backup
function backup()
{
    runlog "INFO | begin to backup."
    current_time=`date -d today +"%Y%m%d%H%M%S%N"`
    backup_file="${BACKUP_PATH}/backup_file_package"
    tmp_dir="${backup_file}/gaussdb_backup_${current_time}"
    if [[ ! -d ${tmp_dir} ]];then
        mkdir -p ${tmp_dir}
    fi
    runlog "INFO | initialize a backup catalog."
    docker exec gaussdb bash /home/backup_restore.sh backup >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        runlog_and_echo "ERROR | backup database failed."
        exit 1
    fi
    docker cp gaussdb:/home/gaussdba/rmandatabackup.tar.gz ${tmp_dir}
    DB_VERSION=$(docker exec gaussdb /opt/gaussdb/app/bin/gs_ctl -V | awk -F " " '{print $2}')
    echo "${DB_VERSION}" > ${tmp_dir}/dj_and_gaussdb_version.json
    cat /opt/huawei/dj/cfg/dj.version >> ${tmp_dir}/dj_and_gaussdb_version.json
    tar -P -czvf ${tmp_dir}/digital_certificate.tar.gz /opt/huawei/dj/DJSecurity >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        runlog_and_echo "ERROR | backup certificate failed."
        exit 1
    fi
    cd ${backup_file} && tar -zcvf ${tmp_dir}.tar.gz $(basename ${tmp_dir})  >> /dev/null 2>&1
    if [[ $? -eq 0 ]];then
        rm -rf ${tmp_dir}
    fi
    csbs_python -c "import kmc.kmc;A=kmc.kmc.API();A.file_hmac(kmc.kmc.KMC_DOMAIN.DEFAULT,'${tmp_dir}.tar.gz')"
    BACKUP_FILE_NAME="${BACKUP_PATH}/$(basename ${tmp_dir}).all.tar.gz"
    cd ${BACKUP_PATH} && tar -zcvf ${BACKUP_FILE_NAME} $(basename ${backup_file})  >> /dev/null 2>&1
    if [[ $? -eq 0 ]];then
        rm -rf ${backup_file}
    fi
    runlog "INFO | backup success."
    echo ${BACKUP_FILE_NAME}
}

prebackup
backup
