#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

############################################
######     脚本退出码如下：           ######
######     10：gaussdb服务异常        ######
######     11：本地备份文件生成失败   ######
######     12：上传文件失败           ######
############################################
BACKUP_PATH='/opt/djbackup/db/manualbk'
HOME_DIR='/opt/huawei/dj/bin/backup/backup'
BACKUP_NUM=7
SENDALARM_PATH="/opt/omm/oma/tools/sendAlarm"
PARAM=''
source ${HOME_DIR}/gaussdb_backup_base.sh

#make sure the backup path is exist
function check_backup_path()
{
    if [[ ! -d ${BACKUP_PATH} ]];then
        runlog " INFO | backup path is not exist."
        mkdir -p ${BACKUP_PATH}
    fi
}

#delete redundant file while it beyond 7 backup files;
function delete_redundant_file()
{
    for dir in `ls -d ${BACKUP_PATH}/gaussdb_backup*`;do
        [[ -d ${dir} ]] && rm -rf ${dir}
    done
    for i in [1..100];do
        file_num=`ls ${BACKUP_PATH} | grep gaussdb_backup | wc -l`
        if [[ ${file_num} -gt ${BACKUP_NUM} ]];then
            oldest_file=`ls -rt ${BACKUP_PATH}/gaussdb_backup* | awk 'NR==1'`
            rm -f ${oldest_file}
            runlog "INFO | delete oldest backup file: ${oldest_file}"
        else
            break
        fi
    done
}

function change_file_mod()
{
    setprivilege ${BACKUP_PATH}
    upload_backup_data -c /opt/huawei/dj/etc/backup/log_agent_dj.json >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        runlog "ERROR | upload backup file and log file failed."
        return 1
    fi
    runlog "INFO | success to upload backup file and log file."
}

function main()
{
    system_time1=$(date +%s)
    hostname=`get_info.py hostname`
    host_ip=`get_info.py manage_ip`
    echo "gaussdbBackup: INFO | Starting to back up data"
    gen_ssh_key
    primary_node=$(get_primary_db_node)
    runlog "INFO | primary node is ${primary_node}"
    #current node is primary node
    if [[ "${host_ip}" == "${primary_node}" ]];then
        runlog "INFO | primary node is: ${primary_node}"
        check_backup_path
        file_name=`sh ${HOME_DIR}/gaussdb_backup.sh ${BACKUP_PATH}`
        if [[ $? -eq 0 ]];then
            file_name_new=`echo ${file_name} | awk 'END {print}'`
            echo "gaussdbBackup: INFO | backup file path is: ${file_name_new}"
            [ "${PARAM}" = "-a" ] && delete_redundant_file
            change_file_mod
            echo "gaussdbBackup: INFO | backup gaussdb successfully."
            ${SENDALARM_PATH} 13295 1 2 "" "${system_time1}" "CPS" "cps" "${hostname}" "${host_ip}"
        else
            echo "gaussdbBackup: ERROR | failed to backup gaussdb."
            ${SENDALARM_PATH} 13295 0 2 "" "${system_time1}" "CPS" "cps" "${hostname}" "${host_ip}"
            rm -f ${SSH_KEY_OUT_FILE}
            exit 11
        fi
    #need execute backup from remote node when not auto backup
    elif [[ "${PARAM}" != "-a" ]];then
        echo "gaussdbBackup: INFO | execute backup from remote node. IP is ${primary_node}"
        runlog "INFO | execute backup from remote node. IP is ${primary_node}"
        ssh ${SSH_OPT} djmanager@${primary_node} ${HOME_DIR}/gaussdb_backup_entry.sh
    else
        change_file_mod
    fi
    rm -f ${SSH_KEY_OUT_FILE}
}

if [ $# -eq 1 ];then
    if [ "$1" = "-a" ];then
        BACKUP_PATH='/opt/djbackup/db'
        PARAM='-a'
    fi
fi
main




