#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

Control_List=
RETRY_TIMES=3
I_TIMES=1
HOME_DIR='/opt/huawei/dj/bin/backup/backup'
source ${HOME_DIR}/gaussdb_backup_base.sh

function restart_all_service()
{
    /usr/bin/bash /opt/huawei/dj/bin/DJControl.sh restart
    if [[ $? -ne 0 ]];then
        runlog_and_echo_restore "ERROR | restart services failed."
        exit 1
    fi
    runlog_and_echo_restore "INFO | restart services success."
}

function start_gaussdb_service()
{    
    #run gaussdb
    for (( i=1; i<=${RETRY_TIMES}; i++ ));do
        /opt/huawei/dj/tools/services/omm-ha/omm-haControl.sh -S STOP >>/dev/null 2>&1
        local ret=$?
        if [[ ${ret} -ne 0 ]];then
            runlog_restore "ERROR | /opt/huawei/dj/tools/services/omm-ha/omm-haControl.sh -S STOP failed,code:${ret}."
            sleep 1
            continue
        fi
        runlog_restore "INFO | /opt/huawei/dj/tools/services/omm-ha/omm-haControl.sh -S STOP success."
        break
    done
        
    sleep 1
    for (( i=1; i<=${RETRY_TIMES}; i++ ));do
        /opt/huawei/dj/tools/services/omm-ha/omm-haControl.sh -S RUN >>/dev/null 2>&1
        local ret=$?
        if [[ ${ret} -ne 0 ]];then
            runlog_restore "ERROR | /opt/huawei/dj/tools/services/omm-ha/omm-haControl.sh -S RUN failed,code:${ret}."
            sleep 1
            continue
        fi
        runlog_restore "INFO | /opt/huawei/dj/tools/services/omm-ha/omm-haControl.sh -S RUN success."
        break
    done
    #check gaussdb container 
    for (( i=1; i<=${RETRY_TIMES}; i++ ));do
        CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
        if [[ "${CONTAINER_ID}" == "" ]];then
            runlog_restore "INFO | gaussdb CONTAINER_ID is not exist."
            sleep 5
            continue
        fi 
        runlog_restore "INFO | gaussdb CONTAINER_ID is exist."
        break
    done
    
    CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
    if [[ "${CONTAINER_ID}" == "" ]];then
        runlog_and_echo_restore "ERROR | start gaussdb failed."
        exit 1
    fi 
    sleep 2
}

function stop_gaussdb_service()
{    
    #stop gaussdb server but don't stop container
    ps -ef | grep cps-monitor | grep omm-ha | awk '{print $2}' | xargs kill -9 >>/dev/null 2>&1
    ps -ef | grep /bin/ha | grep ha_monitor |  awk '{print $2}' | xargs kill -9 >>/dev/null 2>&1
    ps -ef | grep /bin/ha | grep ha.bin |  awk '{print $2}' | xargs kill -9 >>/dev/null 2>&1
    runlog_restore "INFO | kill omm-ha process success."
    CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
    docker exec ${CONTAINER_ID} /bin/bash -c "source /home/gaussdba/.bashrc;cd /opt/gaussdb/app/bin;gs_ctl  stop -D /opt/fusionplatform/data/gaussdb >>/dev/null 2>&1"
    if [[ $? -eq 0 ]];then
        runlog_restore "INFO | gs_ctl  stop -D /opt/fusionplatform/data/gaussdb success."
    fi

    sleep 2
}

function build_gaussdb_data()
{    
    #build gaussdb data on standby
    CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
    docker stop ${CONTAINER_ID} >/dev/null 2>&1
    docker rm -f gaussdb >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        runlog_and_echo_restore "ERROR | rm gaussdb docker failed."
        exit 1
    fi
    sleep 2
    for (( i=1; i<=20; i++ ));do
        bash /usr/local/bin/ha/ha/module/harm/plugin/script/gaussdb.sh "deactive" "standby" "0" 0 "ha2" >>/dev/null 2>&1
        local ret=$?
        if [[ ${ret} -ne 0 ]];then
            runlog_restore "ERROR | start gaussdb with standby failed,code:${ret}."
            sleep 5
            continue
        fi
        runlog_restore "INFO | start gaussdb with standby success."
        break
    done
    
    #check gaussdb container 
    for (( i=1; i<=${RETRY_TIMES}; i++ ));do
        CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
        if [[ "${CONTAINER_ID}" == "" ]];then
            runlog_restore "INFO | start gaussdb with standby CONTAINER_ID is not exist."
            sleep 5
            continue
        fi 
        runlog_restore "INFO | start gaussdb with standby CONTAINER_ID is exist."
        break
    done
    
    CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
    if [[ "${CONTAINER_ID}" == "" ]];then
        runlog_and_echo_restore "ERROR | start gaussdb with standby failed."
        exit 1
    fi

    sleep 5         
    docker exec ${CONTAINER_ID} /bin/bash -c "source /home/gaussdba/.bashrc;cd /opt/gaussdb/app/bin;gs_ctl  build -D /opt/fusionplatform/data/gaussdb -b full -M standby >>/dev/null 2>&1";
    if [ $? -eq 0 ];then
        runlog_restore "INFO | gs_ctl  build -D /opt/fusionplatform/data/gaussdb -b full -M standby success."
    else
        runlog_and_echo_restore "ERROR | gs_ctl  build -D /opt/fusionplatform/data/gaussdb -b full -M standby failed."
        exit 1
    fi
    docker exec ${CONTAINER_ID} /bin/bash -c "source /home/gaussdba/.bashrc;cd /opt/gaussdb/app/bin;gs_ctl  start -D /opt/fusionplatform/data/gaussdb -M standby >>/dev/null 2>&1";
    if [[ $? -eq 0 ]];then
        runlog_restore "INFO | gs_ctl  start -D /opt/fusionplatform/data/gaussdb -M standby success."
    fi
    sleep 2
}

if [[ "$1" = "-start" ]];then
    restart_all_service
elif [[ "$1" = "-startgaussdb" ]];then
    start_gaussdb_service
elif [[ "$1" = "-stopgaussdb" ]];then
    stop_gaussdb_service
elif [[ "$1" = "-buildgaussdb" ]];then
    build_gaussdb_data
fi