#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
CURRENT_DIR=`dirname $(readlink -f $0)`
LOG_FILE='/var/log/huawei/dj/services/system/backup/backup.log'
SSH_KEY_OUT_FILE="/opt/huawei/dj/DJSecurity/ssh/unify_backup_manage"
SSH_OPT="-o StrictHostKeyChecking=no -i ${SSH_KEY_OUT_FILE}"
gen_ssh_key



function start_backup()
{
    gen_ssh_key
    node_list=($(get_info.py manage_ip list | sed 's/,/ /g'))
    result=1
    for node in ${node_list[@]};do
        ssh ${SSH_OPT} djmanager@${node} /usr/sbin/ip a | grep db
        if [ $? -ne 0 ];then
            continue
        fi
        ssh ${SSH_OPT} djmanager@${node} /opt/huawei/dj/bin/backup/backup/gaussdb_backup_entry.sh -a
        result=$?
        break
    done
    rm -f ${SSH_KEY_OUT_FILE}
    if [ ${result} -ne 0 ];then
        log_error "ERROR | exec gaussdb_backup_entry.sh failed."
        exit ${result}
    fi
    log_info "INFO | exec gaussdb_backup_entry.sh success."
    exit 0
}

function enable_backup()
{
    sed -i '/gaussdb_backup_entry.sh/d' /etc/crontab
    if [ ! -f ${CURRENT_DIR}/backup_cron_conf.bk ]; then
        echo "0 0 * * * root /bin/bash /opt/huawei/dj/bin/backup/backup/gaussdb_backup_entry.sh -a >/dev/null 2>&1" >> /etc/crontab
    else
        cat ${CURRENT_DIR}/backup_cron_conf.bk >> /etc/crontab
    fi
    service cron restart
    if [ $? -ne 0 ];then
        log_error "ERROR | add backup timer task to crontab failed."
        exit 1
    fi
    log_info "INFO | add backup timer task to crontab success."
    exit 0
}

function disable_backup()
{
    # backup gaussdb_backup_entry cron config
    local config_num=`cat /etc/crontab | grep "gaussdb_backup_entry.sh" | wc -l`
    if [ ${config_num} -ne 0 ]; then
        cat /etc/crontab | grep "gaussdb_backup_entry.sh" > ${CURRENT_DIR}/backup_cron_conf.bk
    fi

    # delete gaussdb_backup_entry cron config
    sed -i '/gaussdb_backup_entry.sh/d' /etc/crontab
    service cron restart
    if [ $? -ne 0 ];then
        log_error "ERROR | delete backup timer task from crontab failed."
        exit 1
    fi
    log_info "INFO | delete backup timer task from crontab success."
    exit 0
}

function main()
{
    init_log

    cmd=$1

    case ${cmd} in
        start_backup)
            log_info "INFO | receive start_backup cmd."
            start_backup
            ;;
        enable_backup)
            log_info "INFO | receive enable_backup cmd."
            enable_backup
            ;;
        disable_backup)
            log_info "INFO | receive disable_backup cmd."
            disable_backup
            ;;
        *)
            log_error "INFO | receive invalid cmd"
            ;;
    esac
}

main $@