#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
BACKUP_FILE_DIR="/opt/huawei/dj/bin/backup"
PROFILE=`csbs_python /usr/bin/get_info.py profile`
TOOL_PATH='/opt/huawei/dj/tools/services/backup'
VERSION_PATH="/opt/huawei/dj/versions/"


function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/backup"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/backup.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function install_rsyslog()
{
    log_info "Copy rsyslog_backup.conf to ${rsyslog_conf_dir}..."
    /usr/bin/cp -f ${CURRENT_PATH}/rsyslog_backup.conf /etc/rsyslog.d/
    service rsyslog restart
    if [ $? -ne 0 ];then
        log_info "install backup rsyslog conf fail."
        sleep 10
        service rsyslog restart
    fi
    log_info "install backup rsyslog conf success."
}

function install()
{
    mkdir -p ${BACKUP_FILE_DIR}
    /usr/bin/cp -rf ${CURRENT_PATH}/backup ${BACKUP_FILE_DIR}
    csbs_python -m pip install --no-deps --force-reinstall ${LINE_ROOT}/repo/self_developed/log_agent*.whl
    CHECK_RESULT $? "pip install log_agent failed."
    mkdir -p /opt/huawei/dj/bin/backup/log_agent
    setprivilege ${BACKUP_FILE_DIR}
    setprivilege /usr/lib/csbs_python/site-packages
    setprivilege /opt/huawei/dj/etc/backup
    chmod 550 ${BACKUP_FILE_DIR}/backup/*.sh
    log_info "Install backup tar finish"

    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege  ${TOOL_PATH}
    log_info "Copy scripts in ./cli_client to ${TOOL_PATH} finished."

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/backup.ver ${VERSION_PATH}
    setprivilege  ${VERSION_PATH}
    CHECK_RESULT $? "Copy backup.ver to ${VERSION_PATH} failed."
    return 0
}

function set_sudoers_for_backup()
{
    sed -i "/\/serviceControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/bin/backup/backup/serviceControl.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/gaussdb_restore_entry.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/bin/backup/backup/gaussdb_restore_entry.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/gaussdb_restore.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/bin/backup/backup/gaussdb_restore.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/gaussdb_backup_entry.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/bin/backup/backup/gaussdb_backup_entry.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/refresh_backup_conf.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/backup/refresh_backup_conf.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/unify_backup_manage.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/backup/unify_backup_manage.sh" >> /etc/sudoers.d/openstack
}

deploy_uninstall_script
install
install_rsyslog
set_sudoers_for_backup


