#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

sed -i '/gaussdb_backup_entry.sh/d' /etc/crontab
service cron restart
if [ $? -eq 0 ];then
    log_info "delete backup timer task from crontab success."
else
    log_error "delete backup timer task from crontab failed."
fi

if [ -f "/usr/bin/backupControl" ];then
    backupControl -S STOP
    if [ $? -ne 0 ];then
        log_error "stop backup failed."
        exit 1
    fi
    rm -f /usr/bin/backupControl
fi
log_info "stop backup success."

COM_PATH=/opt/huawei/dj/bin/
NFS_MOUNT_PATH=/opt/huawei/dj/bin/backup/log_agent/dj_nfs_backup

if [ -d "$NFS_MOUNT_PATH" ]; then
    mount | grep "$NFS_MOUNT_PATH" > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        umount -f $NFS_MOUNT_PATH > /dev/null 2>&1
    fi
fi

if [ -d "$COM_PATH/backup" ];then
    rm -rf $COM_PATH/backup
fi

rm -rf /opt/huawei/dj/tools/services/backup
rm -rf /opt/huawei/dj/etc/backup
rm -f /etc/rsyslog.d/rsyslog_backup.conf
service rsyslog restart
exit 0