#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/backup_upgrade.log"
CUR_NODE_IDX=$(get_info.py node_index)

##########################################
#
#check upgrade version
#
##########################################

function check_version()
{
    is_need_upgrade backup;ret_val=$?
    if [ ${ret_val} -eq 1 ]; then
        echo -1
        exit 0
    fi
}

function check_rollback()
{
    should_rollback read backup
    if [ $? -ne 0 ];then
        echo "-1"
        log_info "do not need rollback"
        exit 0
    fi
}
if [[ $1 != "upgrade" ]] && [[ $1 != "rollback" ]];then
    echo "-1"
    exit 0
fi
if [[ $1 == "upgrade" ]];then
    check_version
fi
if [[ $1 == "rollback" ]];then
    check_rollback
fi

echo ${CUR_NODE_IDX}