#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/backup_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ];then
        log_error "failed to backup files."
        return 1
    fi
    log_info "success to backup files."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write backup
    if [ $? -ne 0 ];then
        log_error "failed to write backup upgrade flag."
        return 1
    fi
    log_info "success to write backup upgrade flag."
    return 0
}

function install_new_backup()
{
    bash ${CURRENT_DIR}/../uninstall.sh >/dev/null 2>&1
    bash ${CURRENT_DIR}/../install.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "install backup  failed."
        return 1
    fi
    log_info "install backup  success."
    return 0
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    install_new_backup; CHECK_RESULT $?
}

main
log_info "upgrade backup success."
exit 0