#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

function main()
{
    sh ${CURRENT_DIR}/../merge.sh
    if [[ $? -ne 0 ]];then
        log_error "Merge base failed."
        return 1
    fi
    log_info "Merge base success."

    echo '' > ${LINE_ROOT}/bin/osConfig/ssh_config.sh
    log_info "Make ssh_config.sh empty success."

    sh ${CURRENT_DIR}/../install.sh
    if [[ $? -ne 0 ]];then
        log_error "Install base failed."
        return 1
    fi
    log_info "Install base success."

    # 替换kmc秘钥
    cd /root
    tar -zxvf /root/paas.tar.gz
    /usr/bin/cp -rf /root/paas/ /opt/huawei/dj/
    chown -hR root:root /opt/huawei/dj/paas/
    setprivilege /opt/huawei/dj/paas/
    log_info "Copy kmc file success."
    return 0
}

main; CHECK_RESULT $? "Failed to expansion base."
