#!/bin/bash
KEY="kmc.mk_auto_update_policy"

function log_error()
{
    logger -id -n localhost -p local1.error -t update_kmc_key "$1"
}

function log_info()
{
    logger -id -n localhost -p local1.info -t update_kmc_key "$1"
}

function main()
{
    source /opt/huawei/dj/bin/backup/backup/gaussdb_backup_base.sh
    host_ip=`get_info.py manage_ip`
    primary_node=$(get_primary_db_node)
    if [[ "${host_ip}" != "${primary_node}" ]];then
        log_info "This is not primary node, skipped."
        exit 0
    fi
    policy=`csbs_python -c "from basesdk import cms_info;print(cms_info.get_cms_info(\"${KEY}\"))"`
    interval_days=`csbs_python -c "print(${policy}['interval_days'])"`
    let interval_seconds=interval_days*24*60*60
    last_update_time=`csbs_python -c "print(${policy}['last_update_time'])"`
    now=$(date +%s)
    let passed_time=now-last_update_time
    if [[ "${passed_time}" -lt "${interval_seconds}" ]];then
        log_info "It's not time to update master key, skipped."
        exit 0
    fi
    bash /opt/huawei/dj/bin/kmc/kmc_update_master_key.sh
    if [[ $? -ne 0 ]];then
        log_error "Auto update master key failed, try again tomorrow."
        exit 1
    fi
    new_policy=`csbs_python -c "p=${policy};p['last_update_time']=\"${now}\";print(p)"`
    csbs_python -c "from basesdk import cms_info;print(cms_info.put_cms_info(\"${KEY}\", \"${new_policy}\"))"
    if [[ $? -ne 0 ]];then
        log_error "Refresh last update time failed."
        exit 1
    fi
    log_info "Refresh last update time success."
    exit 0
}
main