#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/base_upgrade.log"
PATH1="/cps/components/agent/ascagent"
PATH2="/cps/components/agent/time-sync"
PATH3="/cps/components/agent/keepalived"
ZK_IP=$(get_info.py zookeeper_nodes)

backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
CHECK_RESULT "$?" "Rollback files failed."
log_info "Rollback files success."

new_version=$(read_microservice_ver ${LINE_ROOT}/services/base/base.ver)
remove_image "basepythonimage:${new_version}"
CHECK_RESULT "$?" "Rollback basepythonimage failed."
log_info "Rollback basepythonimage success."

csbs_python -c "from basesdk import kazooClient;zk=kazooClient.get_zk_client_start(\"${ZK_IP}\");zk.delete(\"${PATH1}\",recursive=True);"
csbs_python -c "from basesdk import kazooClient;zk=kazooClient.get_zk_client_start(\"${ZK_IP}\");zk.delete(\"${PATH2}\",recursive=True)"
csbs_python -c "from basesdk import kazooClient;zk=kazooClient.get_zk_client_start(\"${ZK_IP}\");zk.delete(\"${PATH3}\",recursive=True)"
rm -f /usr/bin/check_karbor_connect && ln -sf /opt/huawei/dj/tools/cli-client/check_karbor_connect.py /usr/bin/check_karbor_connect
resource_managerControl -F STOP >/dev/null 2>&1
DJserviceControl restart >/dev/null 2>&1
CHECK_RESULT "$?" "Restart backup service failed."
log_info "Restart backup service success."
sed -i "s# keepalived##g" /opt/huawei/dj/inspect/sh/karbor.sh
sed -i '/^base$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback base success."
exit 0
