#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

function install_rsyslog()
{
    log_info "Init cli_client rsyslog configuration."
    /usr/bin/cp -f ${CURRENT_PATH}/conf/rsyslog_cli_client.conf /etc/rsyslog.d/
    CHECK_RESULT $? "Copy rsyslog_cli_client.conf failed."
    log_info "Restart rsyslog..."
    cmd_retry "service rsyslog restart" 60 5
    CHECK_RESULT $? "Restart rsyslog failed."
    log_info "Finish cli_client rsyslog configuration."
}

function install_script()
{
    log_info "Init cli-client uninstall configuration."
    mkdir -p /opt/huawei/dj/inst/services/cli-client
    /usr/bin/cp -f ${CURRENT_PATH}/cli-client.yaml /opt/huawei/dj/inst/services/cli-client
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh /opt/huawei/dj/inst/services/cli-client
    log_info "Finish cli_client uninstall configuration."
}

function install_tools()
{
    log_info "Init cli_client tools configuration."
    mkdir -p /opt/huawei/dj/tools/services/cli-client
    /usr/bin/cp -f ${CURRENT_PATH}/tools/* /opt/huawei/dj/tools/services/cli-client
    chmod 550 /opt/huawei/dj/tools/services/cli-client/*.sh
    chmod 550 /opt/huawei/dj/tools/services/cli-client/*.py
    log_info "Setting resource_manager tools dir privilege."
    setprivilege  /opt/huawei/dj/tools/services
    log_info "install cli-client rpm."
    csbs_python -m pip install --no-deps --force-reinstall  ${LINE_ROOT}/repo/self_developed/cli_client*.whl
    CHECK_RESULT $? "pip install cli-client failed."
    setprivilege /usr/lib/csbs_python/site-packages
    log_info "Finsih cli-client tools configuration."
}

function install_version()
{
    log_info "Init cli_client version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f ${CURRENT_PATH}/cli-client.ver /opt/huawei/dj/versions/
    log_info "Setting cli_client version dir privilege."
    setprivilege  /opt/huawei/dj/versions/
    log_info "Finsih cli_client version configuration."
}

function install_inspect()
{
    log_info "Init cli_client inspect configuration."
    log_info "Finsih cli_client inspect configuration."
}

function install_crontab()
{
    log_info "Init cli_client crontab configuration."
    log_info "Finsih cli_client crontab configuration."
}

function install_sudoers()
{
    log_info "Init cli_client sudoers configuration."
    /usr/bin/cp -f ${CURRENT_PATH}/conf/sudo_cli_client_conf /etc/sudoers.d/
    CHECK_RESULT $? "Copy sudo_cli_client_conf failed."
    log_info "Finish cli_client sudoers configuration."
}


function set_sudoers_for_cli_client()
{
    sed -i "/\/update_cipher.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/cli-client/update_cipher.sh" >> /etc/sudoers.d/openstack
}

log_info "Start cli_client installation."
install_rsyslog
install_script
install_tools
install_version
install_inspect
install_crontab
install_sudoers
set_sudoers_for_cli_client
log_info "Finish cli_client installation."
