#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
CONFIG_FILE_PATH="/opt/huawei/dj/etc/cms/cms.conf"
db_float_ip=`get_info.py gaussdb_float_ip`
db_cms_password=`get_info.py gaussdb_admin_pwd`
db_ca_file=`get_info.py db_ca_file`
replace_variable db_cms_password ${CONFIG_FILE_PATH}
replace_variable db_float_ip ${CONFIG_FILE_PATH}
replace_variable db_ca_file ${CONFIG_FILE_PATH}
cluster_first_node=$(get_info.py cluster_first_node)

function wait_start()
{
    local count=300
    while [ ${count} -gt 0 ];do
        csbs_python -c "from basesdk import cms_info;exit(cms_info.check_cms_node(\"${cluster_first_node}\"))"
        if [ $? -eq 0 ];then
            return 0
        fi
        let count--
        sleep 5s
    done
    return 1
}

function init_db()
{
    csbs_python -c "from cms import restSrvCtl;exit(restSrvCtl.init_db())"
    return $?
}

if [ $(get_info.py node_index) -eq 1 ];then
    log_info "Begin to init db..."
    cmd_retry  "init_db" 20 10
    CHECK_RESULT  $? "Init cms db failed."
    log_info "Init db finished."
else
    log_info "Begin to wait first node..."
    wait_start; CHECK_RESULT "$?" "Wait cms start on first node failed"
    log_info "Wait first node finished."
fi
exit 0