#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
TOOL_PATH="/opt/huawei/dj/tools/services/cms"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
VERSION_PATH="/opt/huawei/dj/versions/"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/cms"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/cms.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function install_rsyslog()
{
    local rsyslog_conf_dir="/etc/rsyslog.d/"
    log_info "Copy rsyslog_cms.conf to ${rsyslog_conf_dir}..."
    /usr/bin/cp -f ${CURRENT_PATH}/rsyslog_cms.conf ${rsyslog_conf_dir}
    CHECK_RESULT $? "Copy rsyslog_cms.conf ${rsyslog_conf_dir} failed."

    log_info "Restart rsyslog..."
    service rsyslog restart
    if [ $? -ne 0 ];then
       log_info "Restart rsyslog failed, wait 10 seconds to retry..."
       sleep 10
       service rsyslog restart
       log_info "Result code of restarting rsyslog is:$?"
    fi
}

function install()
{
    csbs_python -m pip install --no-deps --force-reinstall  ${LINE_ROOT}/repo/self_developed/cms*.whl
    CHECK_RESULT $? "pip install cms failed."
    setprivilege /usr/lib/csbs_python/site-packages
    setprivilege /opt/huawei/dj/etc/cms
    mkdir -p ${TOOL_PATH}
    /usr/bin/cp ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege  ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/cmsControl_Servicecheck.py
    create_link ${TOOL_PATH}/cmsControl.sh
    CHECK_RESULT $? "Copy ${CURRENT_PATH}/cli_tool to ${TOOL_PATH} failed."

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cms.sh ${INSPECT_SH_PATH}
    setprivilege  ${INSPECT_SH_PATH}
    chmod 750 ${CURRENT_PATH}/cms.sh
    CHECK_RESULT $? "Copy cms.sh to ${INSPECT_SH_PATH} failed."

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f  ${CURRENT_PATH}/cms.ver ${VERSION_PATH}
    setprivilege  ${VERSION_PATH}
    CHECK_RESULT $? "Copy cms.ver to ${VERSION_PATH} failed."
}

function set_sudoers_for_cms()
{
    sed -i "/\/swap_db_user.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/cms/swap_db_user.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/cmsControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/cms/cmsControl.sh" >> /etc/sudoers.d/openstack
}

deploy_uninstall_script
install
install_rsyslog
set_sudoers_for_cms
exit 0