#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/cms_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]]; then
        log_error "Backup cms failed."
        return 1
    fi
    log_info "Backup cms success."

    return 0
}

function set_upgrade_flag()
{
    should_rollback write cms
    if [[ $? -ne 0 ]];then
        log_error "Failed to write cms upgrade flag."
        return 1
    fi
    log_info "Success to write cms upgrade flag."
    return 0
}

function install_new_cms()
{
    config_file="/opt/huawei/dj/etc/cms/cms.conf"
    if [[ -f ${config_file} ]];then
        sed -i "/^connection.*/d"
        cat ${config_file} | grep ^connection >> ${CURRENT_DIR}/../cms.conf
    fi
    cd /opt/huawei/dj/inst/services/cms/ && sh uninstall.sh
    bash ${CURRENT_DIR}/../install.sh >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Install cms failed."
        return 1
    fi
    log_info "Install cms success."
    bash ${CURRENT_DIR}/../config.sh >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Config cms failed."
        return 1
    fi
    log_info "Config cms success."
    cmd_retry "cmsControl -A RESTART" 3 180 >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Start cms failed."
        return 1
    fi
    log_info "Start cms success."
    bash ${CURRENT_DIR}/../post_start.sh >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Post start cms failed."
        return 1
    fi
    log_info "Post start cms success."
    /usr/bin/cp -f  ${CURRENT_DIR}/../uninstall.sh /opt/huawei/dj/inst/services/cms
    /usr/bin/cp -f  ${CURRENT_DIR}/../cms.yaml /opt/huawei/dj/inst/services/cms
    return 0
}

function main()
{
    log_info "Begin to cms cms..."
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    install_new_cms; CHECK_RESULT $?
    set_new_version cms; CHECK_RESULT $?
    log_info "Upgrade cms finished."
    return 0
}

main
log_info "upgrade cms success."
exit 0