#!/bin/bash
LOG_PATH="/var/log/huawei/dj"
LOG_HOME="/var/log"
MAX_LOG_SIZE=100
ROTATE_CONFIG="/opt/huawei/dj/etc/cps-monitor/all"
SYSLOG_CONFIG="/etc/logrotate.d/rsyslog"
SCRIPT_ALL="{\n\tmissingok\n\tdaily\n\tprerotate\n\tendscript\n\tcompress\n\trotate 19\n\tsize=10M\n\tnocreate\n\tcopytruncate\n\tpostrotate\n\tendscript\n}"
SCRIPT_HA="{\n\tmissingok\n\tdaily\n\tprerotate\n\tendscript\n\tcompress\n\trotate 149\n\tsize=10M\n\tnocreate\n\tcopytruncate\n\tpostrotate\n\tendscript\n}"
SCRIPT_DB="{\n\tmissingok\n\tdaily\n\tprerotate\n\tendscript\n\tcompress\n\trotate 69\n\tsize=10M\n\tnocreate\n\tcopytruncate\n\tpostrotate\n\tendscript\n}"
SCRIPT_DOCKER="{\n\tmissingok\n\tdaily\n\tprerotate\n\tendscript\n\tcompress\n\trotate 29\n\tsize=10M\n\tnocreate\n\tcopytruncate\n\tpostrotate\n\tendscript\n}"
# 日志超阈值告警码
ALARM_ID=1020765
log_error()
{
    logger -id -p local1.error -t "log_monitor" "ERROR" "$1"
}

log_waring()
{
    logger -id -p local1.waring -t "log_monitor" "WARING" "$1"
}

log_info()
{
    logger -id -p local1.info -t "log_monitor" "INFO" "$1"
}


function log_processing() {
    touch ${ROTATE_CONFIG}
    chmod 640 ${ROTATE_CONFIG}
    for file in $(find ${LOG_PATH} -name "*.log"); do
        ncount=$(cat ${ROTATE_CONFIG} | grep ${file} | wc -l)
        if [[ ${ncount} -ne 0 ]]; then
            continue
        fi
        echo ${file} >>${ROTATE_CONFIG}
        if [[ $(cat ${file} | grep "/gaussdb/" | wc -l) -ne 0 ]]; then
            echo -e ${SCRIPT_DB} >>${ROTATE_CONFIG}
        elif [[ $(cat ${file} | grep "/docker/" | wc -l) -ne 0 ]]; then
            echo -e ${SCRIPT_DOCKER} >>${ROTATE_CONFIG}
        elif [[ $(cat ${file} | grep "/haproxy/" | wc -l) -ne 0 ]]; then
            echo -e ${SCRIPT_HA} >>${ROTATE_CONFIG}
        else
            echo -e ${SCRIPT_ALL} >>${ROTATE_CONFIG}
        fi
    done
    logrotate ${SYSLOG_CONFIG}
    logrotate ${ROTATE_CONFIG}
}

# 0:告警 1:恢复
function send_alarm() {
    local now=$(date +%s)
    local host_name=$(get_info.py hostname)
    local host_ip=$(get_info.py manage_ip)
    local additional_info="$2;${host_ip}"
    local location_info="CSBS;CSBS-VBS;${host_name}"
    sh /opt/ServiceOM/omm/oma/tools/sendAlarm.sh ${ALARM_ID} $1 2 "" "${now}" \
    "CSBS" "${location_info}" "${location_info}" "${additional_info}" \
     "ServiceOM"

    ret=$?
    log_info "Send alarm with params, \
    serviceom_alarm_id: ${ALARM_ID}, \
    alarm_type:$1, \
    alarm_level:2, \
    now:${now}, \
    service_name:CSBS, \
    alarm_location_info: ${location_info}, \
    alarm_additional_info: ${additional_info}"

    if [[ 0 -eq ${ret} ]];then
      log_info "Send alarm successfully."
      return 0
    else
      log_error "Send alarm failed, return code is ${ret}."
      return ${ret}
    fi
}

function check_big_log_file() {

    local LOG_FILE_LIST=$(find ${LOG_HOME} -type f -size "+${MAX_LOG_SIZE}M" -name "*.log" | awk -F "/" '{print $NF}')
    if [ "${LOG_FILE_LIST}" == "" ]; then
        # 恢复
        send_alarm 1 " "
        if [ $? -eq 0 ]; then
            log_info "The alarm indicating that the log size exceeds the threshold is cleared."
        else
            log_error "Failed to clear the alarm indicating that the log size exceeds the threshold."
        fi
        return
    fi
    # 告警
    local logs=`echo ${LOG_FILE_LIST}`
    log_info "Size threshold-crossing logs:${logs}"
    send_alarm 0 "${logs}"
    if [ $? -eq 0 ]; then
        log_info "The alarm indicating that the number of logs exceeds the threshold is successfully sent."
    else
        log_error "Sending Failure Log Size Exceeds the Threshold."
    fi
}

log_processing
check_big_log_file