#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
sed -i '/^server /d' /etc/ntp.conf

function check_ip(){
    (
        echo "import ipaddress"
        echo "try:"
        echo "    ipaddress.ip_address('$1'.strip())"
        echo "    print('$1'.strip())"
        echo "except ValueError:"
        echo "    print(False)"
    ) | csbs_python
}

domain_regex="^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$"
for ntp_ip in $@;do
    checked_ip=`check_ip ${ntp_ip}`
    if [ "${checked_ip}" != "False" ];then
      sed -i "\$aserver ${checked_ip}" /etc/ntp.conf
      continue
    fi
    if  [[ "${ntp_ip}" =~ ${domain_regex} ]];then
	    sed -i "\$aserver ${ntp_ip}" /etc/ntp.conf
    fi
done
systemctl restart ntpd.service