#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/cps-monitor_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ];then
        log_error "backup cps-monitor failed."
        return 1
    fi
    log_info "backup cps-monitor success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write cps-monitor
    if [ $? -ne 0 ];then
        log_error "failed to write cps-monitor upgrade flag."
        return 1
    fi
    log_info "success to write cps-monitor upgrade flag."
    return 0
}

function unintall_service()
{
    if [ -d /opt/huawei/dj/inst/services/$1 ];then
        cd /opt/huawei/dj/inst/services/$1 && sh uninstall.sh && cd -
    fi
    rm -rf /opt/huawei/dj/inst/services/$1
    rm -rf /opt/huawei/dj/etc/$1
    rm -rf /opt/huawei/dj/bin/$1
    rm -rf /opt/huawei/dj/versions/$1.ver
    rm -rf /opt/huawei/dj/DJSecurity/server-cert/$1
    rm -rf /usr/bin/$1*
}

function upgrade_new_monitor()
{
    sh ${CURRENT_DIR}/../uninstall.sh
    sh ${CURRENT_DIR}/../install.sh
    sh ${CURRENT_DIR}/../start.sh
}

function finish_upgrade_version()
{
    unintall_service "time-sync"
    unintall_service "log_tools"
    unintall_service "ascagent"
    unintall_service "keepalived"
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    upgrade_new_monitor; CHECK_RESULT $?
    finish_upgrade_version; CHECK_RESULT $?
}

main
log_info "upgrade cps-monitor success."
DJserviceControl restart >/dev/null 2>&1
if [ $? -ne 0 ]; then
    log_error "Restart backup service failed."
    exit 1
fi
exit 0