import ast
import json
from sqlalchemy import create_engine
from sqlalchemy import text
from sqlalchemy.orm import sessionmaker

from basesdk import utils

LOG_FILE = '/var/log/huawei/dj/services/system/digital_certificate' \
           '/mo_update_cert.log'
LOG = utils.log_module(LOG_FILE)


def update_internal_cert_task_success():
    password = utils.gaussdb_admin_pwd()
    gaussdb_ip = utils.get_db_float_ip()

    _strconn = "postgresql://gaussdba:%s@%s:5432/cms" % (
        password, gaussdb_ip)
    engine = create_engine(_strconn, echo=True)
    session = sessionmaker(bind=engine)
    dbsession = session()

    try:
        db_ret = dbsession.execute(
            text("select value from config_info where key='cert'"))
        certs_task = ast.literal_eval(db_ret.fetchone()[0])
        for cert_task in certs_task:
            if cert_task.get('cert_name') == "CSBS_VBS-internal":
                cert_task['data'] = {'updateStatus': 'success'}
                break
        dbsession.execute(
            text("update config_info set value=:certs_task where key='cert'"
                 ).bindparams(certs_task=json.dumps(certs_task)))
        dbsession.commit()
    except Exception as err:
        LOG.exception('Update csbs_vbs_internal cert task in the cms db '
                      'failed. msg: {}'.format(err))
        exit(1)

    finally:
        dbsession.close()


if __name__ == '__main__':
    try:
        update_internal_cert_task_success()
    except Exception as err:
        LOG.exception('Update csbs_vbs_internal cert task in the cms db '
                      'failed. msg: {}'.format(err))
        exit(1)
    LOG.info("Update csbs_vbs_internal cert task in the cms db success.")
    exit(0)
