#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/digital_certificate_upgrade.log"

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ]; then
        log_error "Rollback files failed."
        return 1
    fi
    log_info "Rollback files success."
    return 0
}

function main()
{
    rollback_files; CHECK_RESULT $?
}

main
sed -i '/^digital_certificate$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback digital_certificate success."
exit 0