#! /bin/bash
declare optCommand="$1"; shift     # 当前执行操作
source /home/gaussdba/.bashrc
GAUSSDB_DATA="/opt/fusionplatform/data/gaussdb"
LOG_FILE="/var/log/fusionsphere/component/gaussdb/backup_restore.log"
BACKUP_PATH="/home/gaussdba/rmandatabackup"
mkdir -m 750 -p $(dirname ${LOG_FILE}) && touch ${LOG_FILE}
BACKUP_TITLE="====================================================================== Start Mode Current TLI Parent TLI BackupID Status ======================================================================"

function backup_db()
{
    ENCRYPT_DATA=$(grep gaussdb_admin_pwd /opt/huawei/dj/cfg/sys.ini | awk -F '=' '{print $NF}' | sed 's/ //g')
    GAUSSPASSWORD=$(csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")
    rm -rf ${BACKUP_PATH} && mkdir -m 750 -p ${BACKUP_PATH}
    gs_rman init -D ${GAUSSDB_DATA} -B ${BACKUP_PATH} --logging-path=$(dirname ${LOG_FILE})
    if [[ $? -ne  0 ]];then
       echo "Action gs_rman init failed."
       exit 1
    fi
    host=$(cat ${GAUSSDB_DATA}/postgresql.conf | grep listen_addresses | awk -F '=' '{print $NF}' | sed "s/'//g")
    /usr/bin/expect<<-EOF
set timeout 600
spawn gs_rman -d postgres -h ${host} -p 5432 -U gaussdba -D ${GAUSSDB_DATA} -B ${BACKUP_PATH} -Z -b f backup --print-progress
expect {
        "Password for user gaussdba:" {send "${GAUSSPASSWORD}\r"}
       }
lassign [wait] pid spawnid os_error_flag value
exit \${value}
EOF
    timeline=`gs_rman -B ${BACKUP_PATH} show timeline`
    if [[ $? -ne  0 ]] || [[ ${timeline} == "" ]] || [[ ${timeline} == "${BACKUP_TITLE}" ]];then
       echo "gs_rman -B ${BACKUP_PATH} show timeline failed."
       exit 1
    fi
    tar -P -czvf ${BACKUP_PATH}.tar.gz ${BACKUP_PATH} >/dev/null 2>&1
    if [[ $? -ne  0 ]];then
       echo "tar czvf ${BACKUP_PATH}.tar.gz failed."
       exit 1
    fi
    rm -rf ${BACKUP_PATH}
    return 0
}

function restore_db()
{
    if [[ ! -f "${BACKUP_PATH}.tar.gz" ]];then
       echo "File ${BACKUP_PATH}.tar.gz not exist."
       exit 1
    fi
    tar -P -xzvf ${BACKUP_PATH}.tar.gz >/dev/null 2>&1
    if [[ $? -ne  0 ]];then
       echo "tar xzvf ${BACKUP_PATH}.tar.gz failed."
       exit 1
    fi
    timeline=`gs_rman -B ${BACKUP_PATH} show timeline`
    if [[ $? -ne  0 ]] || [[ ${timeline} == "" ]];then
       echo "gs_rman -B ${BACKUP_PATH} show timeline failed."
       exit 1
    fi
    TLI=`echo ${timeline} | sed "s/${BACKUP_TITLE}//" | awk '{print $4}'`
    backupid=`echo ${timeline} | sed "s/${BACKUP_TITLE}//" | awk '{print $6}'`
    if [[ -f "${GAUSSDB_DATA}/postmaster.pid" ]];then
        gs_ctl stop -D ${GAUSSDB_DATA}
        if [[ $? -ne  0 ]];then
           echo "gs_ctl stop gaussdb failed."
           exit 1
        fi
    fi
    sleep 3
    gs_rman -D ${GAUSSDB_DATA} -B ${BACKUP_PATH} restore --recovery-target-timeline  ${TLI}  --backup-id ${backupid}  --print-progress
    return $?
}

case "${optCommand}" in
backup)
    backup_db >> ${LOG_FILE} 2>&1
    exit $?
    ;;

restore)
    restore_db >> ${LOG_FILE} 2>&1
    exit $?
    ;;

*)
    echo "${optCommand} not support." >> ${LOG_FILE}
    exit 1
    ;;
esac
