
if [ "$__INSTALL_FUNCTION_SH__" == "" ]; then
source /home/log.sh
source /home/gaussdba/.bashrc
declare -r gs_s_normal="Normal"                         # 表示数据库双机状态正常。
declare -r gs_s_unknown="Unknown"                       # 表示未知的数据库双机状态。 
declare -r gs_s_needrepair="NeedRepair"                 # 表示数据库需要重建。    
declare -r gs_s_starting="Starting"                     # 表示数据库正在启动。    
declare -r gs_s_waiting="Waiting"                       # 表示正在等待主机降备（备机才有此状态）。  
declare -r gs_s_demoting="Demoting"                     # 表示主机正在进行降备过程（主机才有此状态）。    
declare -r gs_s_promoting="Promoting"                   # 表示备机正在进行升主过程（备机才有此状态）。    
declare -r gs_s_rebuilding="Rebuilding"                 # 表示备机正在进行重建过程（备机才有此状态）。    

# 从数据库中查出的数据库角色值
declare -r gs_r_primary="Primary"                       # 表示本端数据库作为主机使用。
declare -r gs_r_standby="Standby"                       # 表示本端数据库作为备机使用。
declare -r gs_r_cstandby="CascadeStandby"               # 表示本端数据库作为级联备机使用。
declare -r gs_r_pending="Pending"                       # 表示本端数据库处于等待状态，此时可等待通知命令使其成为主机或备机。
declare -r gs_r_normal="Normal"                         # 表示本端数据库作为单机使用。
declare -r gs_r_unknown="UNKNOWN"                       # 表示本端数据库以未知的方式使用。
 

# 从数据库中查出的详细重建原因
declare -r gs_d_normal="Normal"                         # 表示双机关系正常，不需重建
declare -r gs_d_connecting="Connecting"                 # 表示正在尝试进行连接
declare -r gs_d_disconnected="Disconnected"             # 表示未连接
declare -r gs_d_walremoved="WalSegmentRemoved"          # 表示日志段已删除
declare -r gs_d_vernotmatched="VersionNotMatched"       # 表示版本不匹配
declare -r gs_d_modenotmatched="ModeNotMatched"         # 表示模式不匹配
declare -r gs_d_sysIDnotmatched="SystemIDNotMatched"    # 表示数据不是同源的，即双机间的数据目录不是同一个数据库初始化创建的
declare -r gs_d_timenotmatched="TimeLineNotMatched"     # 表示时间线不匹配

declare -i r_success=0
declare -i r_failure=1
declare START_FAIL_RECORD="/home/.startGS.fail" 
declare -i TIMES_TO_REBUILD=3 


# 启动数据库时，指定角色的值
declare -r gs_c_pending="pending"                       #
declare -r gs_c_primary="primary"                       #
declare -r gs_c_standby="standby"                       #
declare -r gs_c_normal="normal"     

# 高斯DB，能够进行重建的原因
declare -r gs_r_canrepair="$gs_d_walremoved|$gs_d_sysIDnotmatched"

declare -r gs_notneedinfo="SENDER_SENT_LOCATION|SENDER_WRITE_LOCATION|SENDER_FLUSH_LOCATION|SENDER_REPLAY_LOCATION|RECEIVER_RECEIVED_LOCATION|RECEIVER_WRITE_LOCATION|RECEIVER_FLUSH_LOCATION|RECEIVER_REPLAY_LOCATION"

# 返回值对应的字符串
declare -a outRetString=("normal" "abnormal" "stopped" "unknown" "starting" "stopping" \
                         "primary" "standby" "activating" "deactivating" "notsupported" "repairing")
    

declare gsCurMode=""                    # 当前数据库配置
declare gsdbSingle="single"             # 高斯DB，单机配置
declare gsdbDouble="double"             # 高斯DB，双机配置


# 返回码
declare -i db_normal=0           #   正常运行
declare -i db_abnormal=1         #   运行异常    
declare -i db_stopped=2          #   停止         
declare -i db_unknown=3          #   状态未知    
declare -i db_starting=4         #   正在启动
declare -i db_stopping=5         #   正在停止
declare -i db_primary=6          #   主正常运行
declare -i db_standby=7          #   备正常运行
declare -i db_activating=8       #   正在升主 
declare -i db_deactivating=9     #   正在降备
declare -i db_notsupported=10    #   动作不存在
declare -i db_repairing=11       #   正在修复

__INSTALL_FUNCTION_SH__='initialized'

fi


isDBRunning()
{
    local -i retVal=0
    local dbinfo=""
    local dbresult=""
    
    # 获取数据运行状态，判断数据库是否正在运行

    dbinfo=$(su gaussdba -s /bin/bash -c 'cd /opt/gaussdb/app/bin; ./gs_ctl status -D /opt/fusionplatform/data/gaussdb/ -U gaussdba')
    # 数据库正在运行
    dbresult=$(echo "$dbinfo" | grep -w "server is running" ); retVal=$?
    if [ $retVal -eq $r_success ] ; then
        return $r_success
    fi
    
    # 数据库不在运行中
    return $r_failure
}

######################################################################
#   FUNCTION   : restartToPrimary
#   DESCRIPTION: 将数据库重启为主的操作
######################################################################
restartToPrimary()
{
    local -i retVal=0
    
    restartToState "$gs_r_primary" "$gs_c_primary" ; retVal=$?
    recordStartResult $retVal
    
    return $retVal    
}

######################################################################
#   FUNCTION   : recordStartResult
#   DESCRIPTION: 记录启动结果，主要是对失败的结果进行记录
#                对于备数据库，一直没能启动成功，需要考虑重建
#####################################################################
recordStartResult()
{
    local -i subRet=$1
    local -i failCount=0
        
    # 启动失败，则需要记录失败的次数
    if [ $subRet -ne $r_success ];then
        failCount=$(cat $START_FAIL_RECORD)
        failCount=$failCount+1
        log_error "DB start failure for $failCount times."
    fi
    
    echo $failCount > $START_FAIL_RECORD
    
    return $r_success
}


######################################################################
#   FUNCTION   : OMM_EXIT
#   DESCRIPTION: 退出函数，用于退出脚本，并输出日志
######################################################################
checkLocalRole()
{
    local checkRole="$1"
    local dbinfo=""
    
    # 获取数据库状态
    dbinfo=$(getDBStatusInfo)
    if ! echo "$dbinfo" | grep -w "LOCAL_ROLE" | grep -wE "$checkRole"; then
        log_error "[checkLocalRole] get role[$checkRole] failure. [$dbinfo]"
        return $r_failure
    fi
    
    return $r_success
}

######################################################################
#   FUNCTION   : getDBStatusInfo
#   DESCRIPTION: 获取数据库状态信息，去除不需要的信息。
#   0 为正在运行
######################################################################
getDBStatusInfo()
{
    su gaussdba -s "/bin/bash" -c "gs_ctl query -D /opt/fusionplatform/data/gaussdb/ -U gaussdba" | grep -vEw "$gs_notneedinfo"
}

######################################################################
#   FUNCTION   : restartToState
#   DESCRIPTION: 重启数据库到目标状态的操作
#   需要输入重启后的检查状态，和重启后的状态，
######################################################################
restartToState()
{
    local chkState="$1"           # 启动后检查的状态
    local staState="$2"           # 启动时的状态
    local -i retVal=0
    
    log_info "start to restart db for $staState, and check state is $chkState."

    # 停止前，先检查当前数据库是否已经停止
    if isDBRunning; then
        # 停止数据库，停止失败，则强制停止
        su gaussdba -s "/bin/bash" -c "gs_ctl stop -m fast" || su gaussdba -s "/bin/bash" -c "gs_ctl stop -m immediate"
    fi

    # 启动数据库为目标状态
    if [ "$staState" == "$gs_c_normal" ]; then
        ps -ef | grep "gs_ctl.*start" | grep -v "grep" >> /dev/null 2>&1
        if [ $? -ne 0 ];then
            su gaussdba -s "/bin/bash" -c "gs_ctl start -w -D /opt/fusionplatform/data/gaussdb/ -U gaussdba"; retVal=$?
        else
            log_info "[restartToState] A start task is running."
        fi
    else
        ps -ef | grep "gs_ctl.*start" | grep -v "grep" >> /dev/null 2>&1
        if [ $? -ne 0 ];then
            su gaussdba -s "/bin/bash" -c "gs_ctl start -w -M ${staState} -D /opt/fusionplatform/data/gaussdb/ -U gaussdba"; retVal=$?
        else
            log_info "[restartToState] A start task is running."
        fi
    fi
        
    # 数据库未启动
    if [ $retVal -ne $r_success ]; then
        log_error "[restartToState] call ($OMM_GS_CTL start [-M $staState]) failure[$retVal]."
        return $r_failure
    fi
    
    # 启动后，需要检查当前数据库是否已经启动
    if ! checkLocalRole "$chkState" ; then
        log_error "[restartToState] call ($OMM_GS_CTL start [-M $staState]) success, but db still not [$chkState]."
        return $r_failure
    fi
    
    log_info "[restartToState] success to restart db for $staState, and check state is $chkState."
    return $r_success
}

######################################################################
#   FUNCTION   : notifyToPrimary
#   DESCRIPTION: 通知数据库角色转换为主的操作
######################################################################
notifyToPrimary()
{
    local -i retVal=0

    # 通知数据库，将状态切换为主用
    su gaussdba -s "/bin/bash" -c "gs_ctl notify -w -M $gs_c_primary -D /opt/fusionplatform/data/gaussdb/ -U gaussdba";retVal=$?
    
    # 通知失败
    if [ $retVal -ne $r_success ]; then
        log_error "[notifyToPrimary] call [$OMM_GS_CTL notify -M $gs_c_primary] failure[$retVal]."
        return $r_failure
    fi
    
    return $r_success
}


######################################################################
#   FUNCTION   : getDBstate
#   DESCRIPTION: 获取数据库状态，从数据库的查询结果中分离出各项信息
#                LOCAL_ROLE, DB_STATE, DETAIL_INFORMATION, PEER_ROLE
######################################################################
getDBState()
{
    local dbinfo="$1"

    LOCAL_ROLE=""; DB_STATE=""; DETAIL_INFORMATION=""; PEER_ROLE="";

    # 目前比较简单的做法，直接从结果中转换，没有再做其他处理
    eval $(echo "$dbinfo" | grep -Ew "LOCAL_ROLE"         | sed -e 's/:/=/g' | sed -e 's/ //g' | sed -n '1p')
    eval $(echo "$dbinfo" | grep -Ew "DB_STATE"           | sed -e 's/:/=/g' | sed -e 's/ //g' | sed -n '1p')
    eval $(echo "$dbinfo" | grep -Ew "DETAIL_INFORMATION" | sed -e 's/:/=/g' | sed -e 's/ //g' | sed -n '1p')
    eval $(echo "$dbinfo" | grep -Ew "PEER_ROLE"          | sed -e 's/:/=/g' | sed -e 's/ //g' | sed -n '1p')
    
    return $r_success
}


######################################################################
#   FUNCTION   : StaToPri
#   DESCRIPTION: 备升主的操作， switchover，失败后尝试强制升主
######################################################################
StaToPri()
{
    local -i retVal=0

    # 备升主，尝试正常切换 switchover
    su gaussdba -s "/bin/bash" -c "gs_ctl switchover -t 90 -D /opt/fusionplatform/data/gaussdb/ -U gaussdba"; retVal=$?
    
    # 切换失败，命令执行失败或是状态没有切换为主用
    if [ $retVal -ne $r_success ] || ! checkLocalRole "$gs_r_primary"; then
        log_error "[notifyToStandby] call [$OMM_GS_CTL switchover -t 90] failure[$retVal], try failover."
        
        # 是否需要尝试多几次后，再试呢？
        StaForceToPri; retVal=$?
        return $retVal
    fi

    # 切换成功
    return $r_success
}

######################################################################
#   FUNCTION   : StaForceToPri
#   DESCRIPTION: 备强制升主的操作， failover
######################################################################
StaForceToPri()
{
    local -i retVal=0

    # 备升主，强制切换 failover
    su gaussdba -s "/bin/bash" -c "gs_ctl failover -D /opt/fusionplatform/data/gaussdb/ -U gaussdba"; retVal=$?
    
    # 切换失败，命令执行失败或是状态没有切换为主用
    if [ $retVal -ne $r_success ] || ! checkLocalRole "$gs_r_primary"; then
        log_error "[notifyToStandby] call [$OMM_GS_CTL failover] failure[$retVal], It can't be helped."
        return $r_failure
    fi
                         
    return $r_success    
}


######################################################################
#   FUNCTION   : restartToStandby
#   DESCRIPTION: 将数据库重启为备的操作
######################################################################
restartToStandby()
{
    local -i retVal=0
    
    restartToState "$gs_r_standby" "$gs_c_standby" ; retVal=$?
    recordStartResult $retVal

    return $retVal
}


######################################################################
#   FUNCTION   : notifyToStandby
#   DESCRIPTION: 通知数据库角色转换为备的操作
######################################################################
notifyToStandby()
{
    local -i retVal=0

    # 通知数据库，将状态切换为备
    su gaussdba -s "/bin/bash" -c "gs_ctl notify -w -M $gs_c_standby -D /opt/fusionplatform/data/gaussdb/ -U gaussdba"; retVal=$?
    
    # 通知失败
    if [ $retVal -ne $r_success ]; then
        log_error "[notifyToStandby] call [$OMM_GS_CTL notify -M $gs_c_standby] failure[$retVal]."
        return $r_failure
    fi
    
    return $r_success
}

######################################################################
#   FUNCTION   : restartToNormal
#   DESCRIPTION: 将数据库重启为正常角色的操作
######################################################################
restartToNormal()
{
    local -i retVal=$r_success
    
    restartToState "$gs_r_normal" "$gs_c_normal"; retVal=$?
    recordStartResult $retVal
    
    return $retVal
}

######################################################################
#   FUNCTION   : restartToPending
#   DESCRIPTION: 将数据库重启为Pending角色的操作
######################################################################
restartToPending()
{
    local -i retVal=0
    
    restartToState "$gs_r_pending" "$gs_c_pending" ; retVal=$?
    recordStartResult $retVal
    
    return $retVal    
}

######################################################################
#   FUNCTION   : isNeedRebuild
#   DESCRIPTION: 判断能否进行重建
#####################################################################
isNeedRebuild()
{
    local -i failCount=0
    local buildStr=""
    
    buildStr=$(su gaussdba -s "/bin/bash" -c "gs_ctl querybuild -D /opt/fusionplatform/data/gaussdb/ -U gaussdba")
    # 如果当前正在进行重建中，则还不需要处理
    if echo "$buildStr" | grep -w "Building" > /dev/null; then
        log_warn "[isNeedRebuild] DB is rebuilding now. [$buildStr]"
        return $db_repairing
    fi
    
    # 当前没有在重建，则判断数据库启动失败是否达到次数
    failCount=$(cat $START_FAIL_RECORD)
    if [ $failCount -gt $TIMES_TO_REBUILD ]; then
        log_error "[isNeedRebuild] DB start failure for $failCount times, need reparid. [$buildStr]"
        return $db_abnormal
    fi
    
    return $db_normal    
}

######################################################################
#   FUNCTION   : PriToSta
#   DESCRIPTION: 主降备的操作，实际就是重启为备
######################################################################
PriToSta()
{
    local -i retVal=0
    
    restartToStandby; retVal=$?
    
    return $retVal    
}