#/bin/bash
function add_gaussdba_if_not_exist()
{
    groupadd -g 51002 dbgrp  > /dev/null 2>&1
    useradd -u 51002 -g dbgrp -d /home/gaussdba -m -s /sbin/nologin gaussdba > /dev/null 2>&1
    sed '/umask/d' /home/gaussdba/.profile && echo "umask 027" >> /home/gaussdba/.profile
    mkdir -p /home/gaussdba && chown -h gaussdba:dbgrp /home/gaussdba && chmod 700 /home/gaussdba
    echo "export PATH=/opt/gaussdb/app/bin:${PATH}" >>/home/gaussdba/.bashrc
    echo "export LD_LIBRARY_PATH=/opt/gaussdb/app/lib:${LD_LIBRARY_PATH}" >>/home/gaussdba/.bashrc
    echo "export GAUSSHOME=/opt/gaussdb/app" >>/home/gaussdba/.bashrc
    echo "export GAUSSDATA=/opt/fusionplatform/data/gaussdb" >>/home/gaussdba/.bashrc
    echo "export PGSSLCERT=/opt/fusionplatform/data/cert/client.crt" >>/home/gaussdba/.bashrc
    echo "export PGSSLKEY=/opt/fusionplatform/data/cert/client.key" >>/home/gaussdba/.bashrc
    echo "export PGSSLROOTCERT=/opt/fusionplatform/data/cert/ca-cert.pem" >>/home/gaussdba/.bashrc
    echo "export PGSSLMODE=require" >>/home/gaussdba/.bashrc
}

function install()
{
    mkdir -p /opt/gaussdb
    tar xf /installfiles/gaussdb_app.tar.gz -C /opt/gaussdb
    CHECK_RESULT $? "install gaussdb in docker fail to unzip gaussdb app"
    add_gaussdba_if_not_exist
    cp /installfiles/* /home/
    chmod 550 /home/*.sh
    chown -h root:dbgrp /home/*.sh
    mkdir -p /opt/fusionplatform/data/{gaussdb,cert}
    rm -rf /opt/fusionplatform/data/gaussdb/pg_log/*.log
    rm -rf /opt/gaussdb/app/bin/*.log
    chmod 750 /opt/gaussdb
    chmod 700 /opt/gaussdb/app
    chmod 700 /opt/gaussdb/app/archive
    chmod 750 /opt/gaussdb/app/bin/
    chmod 550 /opt/gaussdb/app/bin/*
    chmod 550 /opt/gaussdb/app/lib/postgresql/*.so
    chown -hR gaussdba:dbgrp /opt/gaussdb
    chown -hR gaussdba:dbgrp /opt/fusionplatform
    chown -hR gaussdba:dbgrp /opt/huawei
    mkdir -m 750 -p  /var/log/fusionsphere/component/gaussdb
    chown -hR gaussdba:dbgrp /var/log/fusionsphere
    rm /installfiles -rf
    return 0
}
install
