#!/bin/bash

CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

SERV_IMG_NAME="gaussdb"
SERV_IMG_VERSION=$(read_microservice_ver ${LINE_ROOT}/services/gaussdb/gaussdb.ver)
BASE_IMG_VERSION=$(read_microservice_ver ${LINE_ROOT}/services/base/base.ver)

function docker_build()
{
    docker build --force-rm=true -t ${SERV_IMG_NAME}:${SERV_IMG_VERSION} ${CURRENT_PATH}/dockerbuild
}

function make_image()
{
    log_info "Begin to execute docker build..."
    /usr/bin/cp -f ${LINE_ROOT}/repo/platform/gaussdb/gaussdb_app.tar.gz ${CURRENT_PATH}/dockerbuild/installfiles
    CHECK_RESULT $? "Can not find GaussDB APP package."
    replace_variable BASE_IMG_VERSION ${LINE_ROOT}/services/gaussdb/dockerbuild/Dockerfile
    cmd_retry "docker_build" "3" "3"
    if [ $? -eq 0 ];then
        log_info "Execute docker build finished."
    else
        log_error "Execute docker build failed."
        exit 1
    fi
}
make_image