#!/bin/bash

CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
HA_PLUGIN_PATH="/usr/local/bin/ha/ha/module/harm/plugin"
internal_ip_all=

function config_postgresql_conf()
{
    local postgresql_conf='/opt/fusionplatform/data/gaussdb/postgresql.conf'
    chown -hR gaussdba:dbgrp $(dirname ${postgresql_conf})
    local gaussdb_float_ip=`get_info.py gaussdb_float_ip`
    sed -i "s/^listen_addresses.*/listen_addresses='${gaussdb_float_ip}'/g" ${postgresql_conf}
    sed -i "s/.*ssl_cert_file =.*/ssl_cert_file = '..\/cert\/server.crt'/g" ${postgresql_conf}
    sed -i "s/.*ssl_key_file =.*/ssl_key_file = '..\/cert\/server.key'/g" ${postgresql_conf}
    sed -i "s/.*ssl_ca_file =.*/ssl_ca_file = '..\/cert\/ca-cert.pem'/g" ${postgresql_conf}
    sed -i "s/.*ssl_renegotiation_limit =.*/ssl_renegotiation_limit = 0/g" ${postgresql_conf}
    sed -i "s/ssl_ciphers.*/ssl_ciphers = 'ECDHE-RSA-AES256-GCM-SHA384;ECDHE-RSA-AES128-GCM-SHA256'/g"  ${postgresql_conf}
    log_info "change the listen_address to $gaussdb_float_ip"
    local db_peer_node=`get_info.py db_peer_node`
    local local_ip=`get_info.py --manage_ip`
    if [[ "${db_peer_node}" == "None" ]];then
        return
    fi
    local replconninfo='localhost='"${local_ip}"' localport=12211 remotehost='"${db_peer_node}"' remoteport=12211'
    sed -i "/replconninfo1/ c replconninfo1 = '${replconninfo}'" ${postgresql_conf}
    gsFloatIp=`get_info.py gaussdb_float_ip`
    grep "repl_force_cert_check" $gaussdbDataPath/postgresql.conf >> /dev/null
    if [[ $? -ne 0 ]];then
        echo "repl_force_cert_check = 'repl1_peer_cn=$gsFloatIp'" >>${postgresql_conf}
    fi

}

function config_pg_hba()
{
    local pg_hba_file='/opt/fusionplatform/data/gaussdb/pg_hba.conf'
    chown -hR gaussdba:dbgrp $(dirname ${pg_hba_file})
    local flag='# "local" is for Unix domain socket connections only'
    sed -i "/$flag/,$ d" $pg_hba_file
    local to_add_local="local   all             all                                     sha256"
    grep "${to_add_local}" ${pg_hba_file} >> /dev/null
    if [[ $? -ne 0 ]];then
        echo "$to_add_local" >> $pg_hba_file
    fi
    GAUSSDB_FLOAT_IP=`get_info.py --gaussdb_float_ip`
    local to_add_floatip="hostssl    all             all                   ${GAUSSDB_FLOAT_IP}/0    sha256"
    grep "${to_add_floatip}" ${pg_hba_file} >> /dev/null
    if [[ $? -ne 0 ]];then
        echo "$to_add_floatip" >> $pg_hba_file
    fi

}

function wait_start()
{
    local count=300
    while [ ${count} -gt 0 ];do
        csbs_python -c "from basesdk import utils;exit(utils.test_gaussdb_connect())"
        if [ $? -eq 0 ];then
            return 0
        fi
        let count--
        sleep 5s
    done
    return 1
}

function connect_ommha()
{
    mkdir -p ${HA_PLUGIN_PATH}/{conf,script}
    chmod 550 ${CURRENT_PATH}/script/*.sh
    /usr/bin/cp -f ${CURRENT_PATH}/script/*.xml ${HA_PLUGIN_PATH}/conf
    /usr/bin/cp -f ${CURRENT_PATH}/script/*.sh ${HA_PLUGIN_PATH}/script
    setprivilege ${HA_PLUGIN_PATH}
    omm-haControl -A RESTART
}

function start()
{
    config_pg_hba; CHECK_RESULT $? "config_pg_hba failed"
    config_postgresql_conf; CHECK_RESULT $? "config_postgresql_conf failed"
    connect_ommha; CHECK_RESULT $? "connect_ommha failed"
    wait_start; CHECK_RESULT $? "wait_start failed"
}

start