#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/gaussdb_upgrade.log"
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}

function check_gaussdb_container_service_syncstauts()
{
    for (( i=0; i<180; i++ ));do
        if  [[ $i == 179 ]];then
            return 1
        fi
        sleep 2
        docker ps | grep gaussdb | grep -v grep > /dev/null 2>&1
        if [[ $? -ne 0 ]];then
            continue
        fi
        ps -ef | grep gaussdb | grep "/opt/gaussdb/app/bin/gaussdb" | grep "/opt/fusionplatform/data/gaussdb" | grep -v grep > /dev/null 2>&1
        if [[ $? -ne 0 ]];then
            continue
        fi
        #检查synctime
        bash ${LINE_ROOT}/services/gaussdb/sync_monitor.sh check_syncAndTime_status > /dev/null 2>&1
        if [[ $? -eq 1 ]];then
            bash ${LINE_ROOT}/services/gaussdb/sync_monitor.sh reset_status
            continue
        fi
        # 检查同步数据
        bash ${LINE_ROOT}/services/gaussdb/sync_monitor.sh check_status > /dev/null 2>&1
        if [[ $? -eq 1 ]];then
            bash ${LINE_ROOT}/services/gaussdb/sync_monitor.sh reset_status
            continue
        fi
        break
    done
    return 0
}


function switch_gaussdb_service()
{
    local role_info=`bash /usr/local/bin/ha/ha/module/hacom/script/get_harole.sh`
    if [[ "${role_info}" == "active" ]];then
        # 本端降备，对端升主
        local local_node=$(get_info.py manage_ip)
        csbs_python -c "from basesdk import utils;utils.exec_script_of_service_on_node(\"${local_node}\",\"swap-service\",\"omm-ha\")"
    fi
    return 0
}


function set_upgrade_flag()
{
    should_rollback write gaussdb
    if [ $? -ne 0 ];then
        log_error "failed to write gaussdb upgrade flag."
        return 1
    fi
    log_info "success to write gaussdb upgrade flag."
    return 0
}

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ];then
        log_error "failed to backup files."
        return 1
    fi
    log_info "success to backup files."
    backup_image ${CURRENT_DIR}/backup_files/ "gaussdb"
    if [ $? -ne 0 ];then
        log_error "Error to save gaussdb image."
        return 1
    fi
    log_info "backup gaussdb image success."
    return 0
}

function upgrade_gaussdb()
{
    check_gaussdb_container_service_syncstauts
    CHECK_RESULT $? "gaussdb syncstauts not normal"

    switch_gaussdb_service
    CHECK_RESULT $? "switch syncstauts gaussdb failed"

    cmd_retry "omm-haControl -S STOP" 60 5 >/dev/null 2>&1
    CHECK_RESULT $? "Stop omm-ha failed."

    bash ${CURRENT_DIR}/../uninstall.sh >/dev/null 2>&1
    bash ${CURRENT_DIR}/../merge.sh >/dev/null 2>&1
    CHECK_RESULT $? "merge gaussdb image failed."
    log_info "merge gaussdb image success."

    bash ${CURRENT_DIR}/../install.sh "upgrade">/dev/null 2>&1
    CHECK_RESULT $? "install gaussdb  failed."
    log_info "install gaussdb  success."

    bash ${CURRENT_DIR}/../start.sh >/dev/null 2>&1
    CHECK_RESULT $? "start gaussdb  failed."

    check_gaussdb_container_service_syncstauts
    CHECK_RESULT $? "gaussdb syncstauts not normal after upgrade"
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    upgrade_gaussdb; CHECK_RESULT $?
    log_info "Upgrade gaussdb finished."
}

main