#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

function init_db()
{
    csbs_python -c 'from haproxyreg import haporxyregistutil;exit(haporxyregistutil.init_db())'
    return $?
}

function wait_start()
{
    local count=300
    while [[ ${count} -gt 0 ]];do
        rm -f /tmp/haproxy_cfg
        /usr/bin/haproxy_regist export --file-name /tmp/haproxy_cfg
        if [ $? -eq 0 -a -f /tmp/haproxy_cfg ];then
            rm -f /tmp/haproxy_cfg
            return 0
        fi
        rm -f /tmp/haproxy_cfg
        let count--
        sleep 5s
    done
    return 1
}

function main()
{
    log_info "Begin to init db..."
    cmd_retry  "init_db" 10 5
    CHECK_RESULT  $? "Init haproxy db failed."
    log_info "Init db finished."
    log_info "Begin to wait haproxy start."
    wait_start; CHECK_RESULT "$?" "Wait haproxy start failed."
    log_info "Wait haproxy start finished."
}

main
