#!/usr/bin/csbs_python
import threading
import time

from basesdk import utils
from basesdk import kazooClient
from basesdk.cms_info import CMS_ROOT_NODE

LOG = utils.get_logger("haproxy_watcher")
HAPROXY_CFG = 'haproxy.cfg_change'
REFRESH_TOOL = "/etc/huawei/dj/haproxy/bin/refresh_conf.sh"


class HaproxyWatcher(threading.Thread):
    def __init__(self):
        super(HaproxyWatcher, self).__init__()
        self.zk_client = None
        self.start()

    @staticmethod
    def haproxy_hook(info):
        try:
            comp_info = info.decode()
            LOG.info("Key: %s. Value %s " % (HAPROXY_CFG, comp_info))
            ret, _ = utils.run_cmd(["proc_manager", "-start", REFRESH_TOOL])
            if ret != 0:
                LOG.error("Execute cmd to refresh haproxy config file failed.")
        except Exception:
            LOG.error("Execute haproxy_hook exception.")

    def run(self):
        while 1:
            try:
                if not self.zk_client:
                    self.zk_client = kazooClient.get_zk_client_start(
                        utils.get_zk_ip())
                    node_path = '/'.join([CMS_ROOT_NODE, HAPROXY_CFG])
                    kazooClient.register_data_watch(
                        self.zk_client, node_path, self.haproxy_hook)
            except Exception:
                LOG.error("Register data watch failed")
            time.sleep(10)


HaproxyWatcher()
