#!/bin/bash

install_haproxy()
{
    rpm -Uivh /installfiles/haproxy*.rpm --force --nodeps
    if [ $? -ne 0 ];then
        echo "Install rpms failed."
        exit 1
    fi
    csbs_python -m pip install --no-deps --force-reinstall  /installfiles/haproxyreg*.whl
    CHECK_RESULT $? "pip install haproxyreg failed."
    echo "Install rpms successfully."
    mkdir -p /etc/huawei/dj/haproxy/{bin,cfg,tmp}
    /usr/bin/cp /installfiles/haproxy_run.sh /etc/huawei/dj/haproxy/bin/
    /usr/bin/cp /installfiles/generage_conf.sh /etc/huawei/dj/haproxy/bin/
    /usr/bin/cp /installfiles/refresh_conf.sh /etc/huawei/dj/haproxy/bin/
    /usr/bin/cp /installfiles/utils.sh /etc/huawei/dj/haproxy/bin/
    /usr/bin/cp /installfiles/haproxy_watcher.py /etc/huawei/dj/haproxy/bin/
    chown -hR root:openstack /etc/huawei >/dev/null 2>&1
    find /etc/huawei -type f -name "*.sh" | xargs -I{} chmod 550 {} >/dev/null 2>&1
    find /etc/huawei -type f -name "*.py" | xargs -I{} chmod 550 {} >/dev/null 2>&1
    mkdir -p /var/log/huawei/dj/services/system/{haproxy,kmc} >/dev/null 2>&1
    chown -hR root:openstack /var/log/huawei >/dev/null 2>&1
    chmod 770 /etc/huawei/dj/haproxy/{cfg,tmp} >/dev/null 2>&1
    chown -hR openstack:openstack /usr/lib/csbs_python/site-packages
    chown -hR root:openstack /usr/sbin/haproxy*
    chown -hR root:openstack /opt/huawei
    rm /installfiles -rf
    echo "Install haproxy successfully."
}

install_haproxy