#!/bin/bash
. /etc/huawei/dj/haproxy/bin/utils.sh

log_error()
{
    logger -id -n localhost -p local1.error -t haproxyrun "${MAIN_PLANE} $1"
}

log_info()
{
    logger -id -n localhost -p local1.info -t haproxyrun "${MAIN_PLANE} $1"
}

log_info "Begin to refresh haproxy config file."

HAPROXY_ROOT_PATH='/etc/huawei/dj/haproxy'
HAPROXY_BIN_DIR="${HAPROXY_ROOT_PATH}/bin"
HAPROXY_CFG_DIR="${HAPROXY_ROOT_PATH}/cfg"


#generate config file
log_info "Begin to generate haproxy config file."
flock -w 10 -E 1 -x /tmp/haproxy_regist.lock -c "bash /etc/huawei/dj/haproxy/bin/generage_conf.sh"
if [[ $? -ne 0 ]];then
    log_error "Generate config file failed."
    exit 1
fi

#reload haproxy
log_info "Begin to reload haproxy config file."
reload_haproxy_with_key "${HAPROXY_CFG_DIR}/haproxy.cfg" "${HAPROXY_CFG_DIR}/haproxy.pid"  $(cat "${HAPROXY_CFG_DIR}/haproxy.pid")
if [[ $? -ne 0 ]];then
    log_error "Reload haproxy failed."
    exit 1
fi
log_info "Refresh haproxy config file finished."
