#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/haproxy_upgrade.log"

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]];then
        log_error "Failed to rollback files."
        return 1
    fi
    log_info "Success to rollback files."
    return 0
}

function rollback_haproxy_container()
{
    # rollback container
    cmd_retry "haproxyinternalControl -S STOP" 120 5 >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Stop haproxy failed."
        return 1
    fi
    log_info "Stop haproxy success."
    cmd_retry "docker rm -f haproxyinternal" 10 5 >/dev/null 2>&1
    check_container=`docker ps -a | grep haproxyinternal | wc -l`
    if [[ ${check_container} -ne 0 ]];then
        log_error "Remove container failed."
        return 1
    fi
    log_info "Remove container success."
    new_version=$(read_microservice_ver ${LINE_ROOT}/services/haproxy/haproxy.ver)
    remove_image "haproxy:${new_version}"; CHECK_RESULT $?
    rollback_files; CHECK_RESULT $?
    rollback_image ${CURRENT_DIR}/backup_files/ "haproxy"
    if [[ $? -ne 0 ]];then
        log_error "Error to rollback haproxy image."
        return 1
    fi
    log_info "Rollback haproxy image success."
    cmd_retry "haproxyinternalControl -A RESTART" 120 5 >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Start haproxy failed."
        return 1
    fi
    log_info "Start haproxy success."
    return 0
}
rollback_haproxy_container; CHECK_RESULT $?
sed -i '/^haproxy$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback haproxy success."
exit 0
