#!/bin/bash
export PATH=/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/games:/usr/lib/mit/bin:/usr/lib/mit/sbin:$PATH
tp=$4
log_dir="/opt/djcollect/DataCollect_${tp}"
err_file="$log_dir/tool_error"
node_name=`hostname`
my_node_dir=${log_dir}/$node_name
MY_NODE=$(csbs_python /usr/bin/get_info.py --manage_ip)
COLLECT_TOOL="/opt/huawei/dj/inspect/DataCollect.sh"
source /opt/huawei/dj/inst/bin/utils.sh

function setupLogfile
{
    if ! [ -z "$1" ]
    then
        if [ ! -e "$1" ];then
            mkdir -p $(dirname $1)
            >$1
        fi
        output_fd=3
        output_fd_error=4
        exec 3>&1
        exec 4>&2
        exec 2>>$1
        exec 1>>$1

    else
        output_fd=3
        output_fd_error=4
        exec 3>&1
        exec 4>&2
    fi
    tim=`date`
    echo "============$0: $tim============="
}

function unsetupLogfile
{
    if ! [ -z "$output_fd" ] && ! [ -z "$output_fd_error" ]
    then
        set +x
        exec 2>&$output_fd_error
        exec 1>&$output_fd
        output_fd=0
        output_fd_error=0
    fi
}


setupLogfile /var/log/huawei/dj/dj_collect.log


function send_cmd()
{
    x=`ip addr | grep "inet $ip" | wc -l`
    usage=`df /opt |grep '/' |awk '{print $5}' |cut -d '%' -f 1`
    if [[ $x -gt 0 ]];then
        if [[ -n "$usage" ]] && [[ $usage -ge 80 ]];then
            echo "ERROR:node:$node_name space used ${usage} is more than 80%."
            rm -rf ${log_dir}
            exit 1
        fi
    fi
    local ret=""
    ${COLLECT_TOOL} $@
    ret=$?
    if [ $ret -ne 0 ];then
        echo "ERROR:node ${MY_NODE} run:$COLLECT_TOOL $@ failed."
    fi
}

function finish_collect()
{
    ${COLLECT_TOOL} $@
    rm -f ${SSH_KEY_OUT_FILE}
    cd "$(dirname ${log_dir})" && tar -cvf /opt/djcollect/DataCollect"_${tp//:/_}".tar * && rm -rf ${log_dir}
    chmod 640 /opt/djcollect/DataCollect"_${tp//:/_}".tar
    setprivilege /opt/djcollect/

    exit 0
}

unsetupLogfile
rm -f /var/log/huawei/dj/dj_collect.log

Control_id=$1

case $Control_id in
    finish)
        finish_collect $@
    ;;
    *)
        send_cmd $@
esac
exit $?