#!/bin/bash
export PATH=/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/games:/usr/lib/mit/bin:/usr/lib/mit/sbin:$PATH
tp=$4
constant=90
log_dir=/opt/djcollect/DataCollect"_${tp}"
node_name=`hostname`
my_node_dir=${log_dir}/$node_name

function setupLogfile
{
    if ! [ -z "$1" ]
    then
        if [ ! -e "$1" ];then
            mkdir -p $(dirname $1)
            >$1
        fi
        output_fd=3
        output_fd_error=4
        exec 3>&1
        exec 4>&2
        exec 2>>$1
        exec 1>>$1

    else
        output_fd=3
        output_fd_error=4
        exec 3>&1
        exec 4>&2
    fi
    tim=`date`
    echo "============$0: $tim============="
}

function unsetupLogfile
{
    if ! [ -z "$output_fd" ] && ! [ -z "$output_fd_error" ]
    then
        set +x
        exec 2>&$output_fd_error
        exec 1>&$output_fd
        output_fd=0
        output_fd_error=0
    fi
}

function prepare_collect()
{
    tp=$1
    log_dir=/opt/djcollect/DataCollect"_${tp}"
    my_node_dir=${log_dir}/$node_name
    #check disk opt space to store file;need more than 1G
    local requiredSpace_opt=1024000 #1000*1024 K
    local space_size_opt=`df -k /opt/djcollect |tail -n 1|awk '{print $4}'`
    if [ -n "$space_size_opt" ] && [ $space_size_opt -gt $requiredSpace_opt ];then
        mkdir -p $my_node_dir
    else
        echo "ERROR:node:$node_name space $space_size_opt is not enough to store log."
        exit 1
    fi
    exit 0
}

function finish_collect()
{
    usage=`df /opt/djcollect |grep '/' |awk '{print $5}' |cut -d '%' -f 1`
    list=${log_dir}/$node_name/*
    if [[ -n "$usage" ]] && [[ $usage -ge $constant ]];then
        echo "ERROR:node:$node_name space $space_size_opt is more than 90%."
        rm -rf $list
    else
        rm -f ${my_node_dir}.tar
        cd $(dirname ${my_node_dir})
        tar -cvf ${my_node_dir}.tar $(basename $my_node_dir) >/dev/null 2>&1
        rm -rf $my_node_dir
    fi
}



function collect_sys_info()
{
    usage=`df /opt/djcollect |grep '/' |awk '{print $5}' |cut -d '%' -f 1`
    list=${log_dir}/$node_name/*
    if [[ -n "$usage" ]] && [[ $usage -ge $constant ]];then
        echo "ERROR:node:$node_name space $space_size_opt is more than 90%."
        rm -rf $list
    else
        sys_info=$my_node_dir/sys_info.txt
        if [ -e "${sys_info}" ];then
            rm ${sys_info}
        fi
        local var_log_dir="/var/log"
        echo "================================= System Info =================================" >> $sys_info
        echo "CPU" >> $sys_info
        top -n 1 -b | grep 'Cpu' >> $sys_info
        echo "-------------------------------------------------------------------------------" >> $sys_info
        echo "Memory" >> $sys_info
        top -n 1 -b | grep 'Mem' >> $sys_info
        echo "-------------------------------------------------------------------------------" >> $sys_info
        echo "Log Space" >> $sys_info
        df -h $var_log_dir >> $sys_info
        echo "-------------------------------------------------------------------------------" >> $sys_info
        echo "System boot" >> $sys_info
        date -d "$(awk -F. '{print $1}' /proc/uptime) second ago" +"%Y-%m-%d %H:%M:%S" >> $sys_info
        echo "-------------------------------------------------------------------------------" >> $sys_info
        echo "iptables" >> $sys_info
        iptables -nvL >> $sys_info
        echo "-------------------------------------------------------------------------------" >> $sys_info
        echo "dbInfo" >> $sys_info
        CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
        if [ "$CONTAINER_ID" != "" ];then
           docker exec $CONTAINER_ID /bin/bash -c "source /home/gaussdba/.bashrc;cd /opt/gaussdb/app/bin;gs_ctl query" >> $sys_info
        else
           echo" "
        fi
        echo "===============================================================================" >> $sys_info
        cluser_info=$my_node_dir/cluser_info.txt
        if [ -e "${cluser_info}" ];then
            rm ${cluser_info}
        fi
        echo "DJ cluser info:" >> $cluser_info
        echo "Node sub:"  >> $cluser_info
        get_info.py all_node >> $cluser_info
        echo "This node name:" >> $cluser_info
        hostname >> $cluser_info
        echo "internal_ip list:" >> $cluser_info
        get_info.py manage_ip list >> $cluser_info
        echo "is online:("y" is online,"n" is not online)" >> $cluser_info
        nodeSub=`get_info.py node`
        if [[ $nodeSub -eq 1 ]];then
            echo "y" >> $cluser_info
            exit 0
        fi
        for ((i=1; ; i++))
        do
            ip=`get_info.py manage_ip list |cut -d ',' -f $i`
            ret=`echo $ip |grep '.'`
            if [ "" = "$ret" ];then
                exit 0
            fi
            my_number=`karbor_ping $ip -i 0.1 -c 5 |grep "64 bytes from"|wc -l`
            get_info.py manage_ip list |cut -d ',' -f $i >> $cluser_info
            if [[ $my_number -eq 5 ]];then
                echo "y" >> $cluser_info
            else
                echo "n"
            fi
        done           
        echo "===============================================================================" >> $sys_info
    fi 
}

function collect_version_info()
{
    usage=`df /opt/djcollect |grep '/' |awk '{print $5}' |cut -d '%' -f 1`
    list=${log_dir}/$node_name/*
    if [[ -n "$usage" ]] && [[ $usage -ge $constant ]];then
        echo "ERROR:node:$node_name space $space_size_opt is more than 90%."
        rm -rf $list
    else
        local version_file="/opt/huawei/dj/cfg/dj.version"
        if [ -e "$version_file" ];then
           cp -f $version_file $my_node_dir
        fi
    fi
    return 0
}

function collect_compenents_log()
{
    usage=`df /opt/djcollect |grep '/' |awk '{print $5}' |cut -d '%' -f 1`
    list=${log_dir}/$node_name/*
    if [[ -n "$usage" ]] && [[ $usage -ge $constant ]];then
        echo "ERROR:node:$node_name space $space_size_opt is more than 90%."
        rm -rf $list
    else
        start=start_time_file
        end=end_time_file
        touch -t $start_time $start
        touch -t $end_time $end
        local compenents_name=$1
        local log_dir="/var/log/huawei/dj/services/system"
        local collect_to_dir=${my_node_dir}/${log_dir}
        local count=$(find $log_dir -name "$compenents_name*")
        if [ -n "$count" ];then
            mkdir -p $collect_to_dir
            cp -rf --preserve $log_dir/$compenents_name* $collect_to_dir
            find  $collect_to_dir/$compenents_name* -type f ! -newer $start -o -type f -newer $end | xargs rm
        fi
        
        local log_dir1="/var/log/huawei/dj/services/operate"
        local collect_to_dir1=${my_node_dir}/${log_dir1}
        local count1=$(find $log_dir1 -name "$compenents_name*")
        if [ -n "$count1" ];then
            mkdir -p $collect_to_dir1
            cp -rf --preserve $log_dir1/$compenents_name* $collect_to_dir1
            find  $collect_to_dir1/$compenents_name* -type f ! -newer $start -o -type f -newer $end | xargs rm
        fi

        rm $start $end -rf
    fi
    return $?
}

check_id=`echo "Control_id=$1"`
check_file=${my_node_dir}/collect_run.log
cat ${check_file} | grep "${check_id}" >/dev/null 2>&1
if [ $? -eq 0 ];then
    rm ${check_file}
fi
setupLogfile ${my_node_dir}/collect_run.log
set -x
ls -l /opt/djcollect/DataCollect"_${tp}"
Control_id=$1
start_time=$2
end_time=$3
sufix=$4
case $Control_id in
    00)
        prepare_collect $sufix
    ;;
    10)
        collect_sys_info
    ;;
    11)
        collect_version_info
    ;;
    20)
        collect_compenents_log "cps-monitor"
    ;;
    23)
        collect_compenents_log "zookeeper"
    ;;
    24)
        collect_compenents_log "gaussdb"
    ;;
    25)
        collect_compenents_log "haproxy"
    ;;
    26)
        collect_compenents_log "rabbitmq"
    ;;
    28)
        collect_compenents_log "karbor"
    ;;
    210)
        collect_compenents_log "scagent"
    ;;
    211)
        collect_compenents_log "cms"
    ;;
    212)
        collect_compenents_log "digital_certificate"
    ;;
    213)
        collect_compenents_log "kmc"
    ;;
    214)
        collect_compenents_log "ha"
    ;;
    215)
        collect_compenents_log "alarm"
    ;;
    216)
        collect_compenents_log "cli-client"
    ;;
    218)
        collect_compenents_log "resource_manager"
    ;;
    finish)
        finish_collect
    ;;
    *)
        echo "ERROR:no comand find for $@."
        exit 0
esac

exit $?
