#!/usr/bin/env bash
# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: WriteResultHeaderToXml
# Description: Write Fixed Format Header To The Result File
# Parameter:
# Return:
# **************************************************************************** #
WriteResultHeaderToXml()
{
    echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" >>$CHECK_RESULT_FILE
    echo "<device>" >>$CHECK_RESULT_FILE
    echo "  <cmditem id=\""$1"\">"  >>$CHECK_RESULT_FILE    
}


# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: WriteErrorItemResultToXml
# Description: Write Fixed Error Format To The Result File
# Parameter:
# Return:
# **************************************************************************** #
WriteErrorItemResultToXml()
{
    errorCode=1
    if [ $# -eq 4 ];then
        errorCode=$4
    fi
    echo "      <item id="\"$1\"">" >>$CHECK_RESULT_FILE
    echo "          <errorvalue type=\"$2\">$3</errorvalue>" >>$CHECK_RESULT_FILE
    echo "          <judge>"$errorCode"</judge>" >>$CHECK_RESULT_FILE
    echo "      </item>" >>$CHECK_RESULT_FILE
}

# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: WriteNormalItemResultToXml
# Description: Write Fixed Normal Format To The Result File
# Parameter:            
# Return:
# **************************************************************************** #
WriteNormalItemResultToXml()
{
    echo "      <item id=\""$1"\">" >>$CHECK_RESULT_FILE
    echo "          <commonvalue type=\"$2\">$3</commonvalue>" >>$CHECK_RESULT_FILE
    echo "          <judge>"0"</judge>" >>$CHECK_RESULT_FILE
    echo "      </item>" >>$CHECK_RESULT_FILE
}

# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: WriteNormalItemResultToXml
# Description: Write Fixed Format End To The Result File
# Parameter:            
# Return:
# **************************************************************************** #
WriteResultEndToXml()
{   
    echo "  </cmditem>" >>$CHECK_RESULT_FILE
    echo "</device>" >>$CHECK_RESULT_FILE
}

# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: InitFile
# Description: Initialization Result Files
# Parameter:
# Return:
# **************************************************************************** #
InitFile ()
{
    FileName="$*"
    [ -f $FileName ] && rm -rf $FileName 
    touch ${FileName}
}

# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: IsProcessExist
# Description: IsProcessExist
# Parameter: $1 进程名称, $2 输出到报告中的进程名称($2 可选) 
# Return: 进程的个数
# **************************************************************************** #
IsProcessExist ()
{
    item=$1
    processNameShort=$2
    service_name=$3
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    cd ${INSPECT_SH}
    bash ${INSPECT_SH}/${service_name}.sh "$item"  >/dev/null 2>&1
    line=$?
    if [ $line -eq 0  ]
    then
        echo "$processNameShort:Exist"
    else
        echo "$processNameShort:Not Exist"
    fi
    cd - >/dev/null 2>&1
    return $line
}

check ()
{
    ret=0
    msg=''
    while [ $# -ne 0 ];do
        msg=$msg'||'`IsProcessExist "$1" "$2" "$3"`
        if [ $? -ne 0 ];then
            ret=1
        fi
        shift;shift;shift
    done
    
    if [ "${msg:0:2}" == '||' ];then 
        msg=${msg:2}
    fi
    echo $msg
    return $ret
}

function check_logon()
{
    local host=$1
    local user=$2
    local sshopt="$3"

    ssh $sshopt $user@$host 'ls /tmp' >/dev/null 2>&1
    return $?
}


# 执行命令，并输出执行好的组合信息,返回执行成功的节点的数量
function exec_cmd ()
{
    node=""
    ret=""
    msg=""
    ret=0
    for node in ${NODE_LIST[@]};do
        if [ "X$MY_NODE" == "X$node" ];then
            msg=$msg'||'`/usr/bin/bash ${INSPECT_TOOL} ${node} $@`
        else
            msg=$msg'||'`ssh ${SSH_OPT} djmanager@${node} "/usr/bin/bash ${INSPECT_TOOL} ${node} $@"`
        fi
        result=$?
        if [ $result -eq 0 ];then
            ((ret+=1))
        fi
        if [ $result -eq 10 ];then
            ((ret+=10)) #N/A 不涉及
        fi

    done

    if [ "${msg:0:2}" == '||' ];then
        msg=${msg:2}
    fi
    echo $msg
    return $ret #执行成功的节点的数量 ret除以10的余数 ret%10
}

# 在所有点上执行命令
# 所有节点均成功，返回 0 (成功)
# 若有一个节点执行失败，返回 1 (执行失败)
function exec_cmd_all_node ()
{
    nodeCount=`csbs_python /usr/bin/get_info.py node`
    exec_cmd $@
    succNodeCount=$?
    if [ $succNodeCount -eq $[nodeCount * 10] ] ;then
        return 0 
    fi
    if [ $succNodeCount -eq $nodeCount ];then
        return 0 #成功
    fi
    return 1 #失败
}

# 在所有节点执行命令
# 有且仅有一个节点执行成功，返回 0 (成功)
# 否则返回 1 (失败)
function exec_cmd_only_1_node_succ ()
{
    nodeCount=`csbs_python /usr/bin/get_info.py node`
    exec_cmd $@
    succNodeCount=$? 
    if [ $succNodeCount -eq $[nodeCount * 10] ] ;then
        return 0 
    fi
    if [ $[succNodeCount % 10] -eq 1 ];then
        return 0
    fi
    return 1
}


# 在所有节点执行命令
# 有且仅有两个节点执行成功，返回 0 (成功)
# 否则返回 1 (失败)
function exec_cmd_only_2_node_succ ()
{
    nodeCount=`csbs_python /usr/bin/get_info.py node`
    exec_cmd $@
    succNodeCount=$?
    if [ $succNodeCount -eq $[nodeCount * 10] ] ;then
        return 0 
    fi
    if [ $[succNodeCount % 10] -eq 2 ];then
        return 0
    fi
    return 1
}