#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
INSPECT_FILE_DIR="/opt/huawei/dj"
LOG_FILE="/var/log/huawei/dj/install.log"
VERSION_PATH="/opt/huawei/dj/versions/"
TOOL_PATH="/opt/huawei/dj/bin"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/inspect"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/inspect.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}


function install()
{    
    if [[ ! -d "${INSPECT_FILE_DIR}" ]];then
        mkdir -p ${INSPECT_FILE_DIR}
    fi
    /usr/bin/cp -rf  ${CURRENT_PATH}/inspect ${INSPECT_FILE_DIR}
    setprivilege  ${INSPECT_FILE_DIR}/inspect
    # DataCollect.sh and DJCollect.sh.sh 750 privilege for SmartKit
    chmod 750 ${INSPECT_FILE_DIR}/inspect/DataCollect.sh
    chmod 750 ${INSPECT_FILE_DIR}/inspect/DJCollect.sh

    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/showsys.sh ${TOOL_PATH}
    setprivilege ${TOOL_PATH}
    create_link /opt/huawei/dj/bin/showsys.sh

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/inspect.ver ${VERSION_PATH}
    setprivilege ${VERSION_PATH}
    return 0
}

deploy_uninstall_script
install
log_info "Install inspect&collect tools success."

