#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

schedule_interval=$1
if [[ ! "${schedule_interval}" =~ ^[[:digit:]]*$ ]]; then
    echo "Input para error."
    exit 1
fi

PROFILE=$(get_info.py --profile)
NODE=$(get_info.py --node_index)

if [[ ${PROFILE} != "public" ]] && [[ ${NODE} -eq 1 ]] && [[ "${schedule_interval}" -gt 0 ]] && [[ "${schedule_interval}" -lt 32 ]];then
    sed -i '/inspect_long_running_baks\.sh/d' /etc/crontab
    if [[ ${schedule_interval} -eq 1 ]];then
        echo "0 12 * * * root /bin/bash /opt/huawei/dj/etc/karbor/inspect_long_running_baks.sh >/dev/null 2>&1" >> /etc/crontab
    else
        echo "0 12 */${schedule_interval} * * root /bin/bash /opt/huawei/dj/etc/karbor/inspect_long_running_baks.sh >/dev/null 2>&1" >> /etc/crontab
    fi
    service cron restart
fi