#!/usr/bin/env bash
if [[ ${UID} -ne 0 ]];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
source /opt/huawei/dj/inst/bin/utils.sh
SYS_INI="/opt/huawei/dj/cfg/sys.ini"
SERVICES=(cps-monitor cms rabbitmq karbor-api karbor-protection karbor-operation)

function set_zk_nodes()
{
    write_ini_file FEATURE public_zookeeper_nodes $1 ${SYS_INI}
}

function set_password()
{
    write_ini_file FEATURE public_zookeeper_password $1 ${SYS_INI}
}

function sync_cert_file()
{
    zk_source_keyfile="/tmp/zk_keyfile.pem"
    zk_source_ca="/tmp/zk_ca.cer"
    zk_dest_dir="/opt/huawei/dj/DJSecurity/server-cert/zookeeper"
    if [[ ! -d ${zk_dest_dir} ]]; then
        mkdir ${zk_dest_dir}
    fi

    mv ${zk_source_keyfile} ${zk_dest_dir}
    chmod 640 ${zk_dest_dir}/zk_keyfile.pem
    chown -h root:openstack ${zk_dest_dir}/zk_keyfile.pem

    mv ${zk_source_ca} ${zk_dest_dir}
    chmod 640 ${zk_dest_dir}/zk_ca.cer
    chown -h root:openstack ${zk_dest_dir}/zk_ca.cer
}

function restart_service()
{
    for service in ${SERVICES[@]}
    do
        ${service}Control -A RESTART
    done
}

function stop_zookeeper()
{
    zookeeperControl -S STOP
}

zk_nodes=`echo $1|awk -F "_" '{print $1}'`
password=`echo $1|awk -F "_" '{print $2}'`
set_zk_nodes ${zk_nodes}
set_password ${password}
sync_cert_file
restart_service
stop_zookeeper
