#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
log_info "Start karbor installation."
TOOL_PATH='/opt/huawei/dj/tools/services/karbor'
VERSION_PATH="/opt/huawei/dj/versions/"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
KARBOR_CONF_DIR='/opt/huawei/dj/etc/karbor'

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/karbor"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/karbor.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function install_rsyslog()
{
    local rsyslog_conf_dir="/etc/rsyslog.d/"
    log_info "Copy rsyslog_karbor.conf to ${rsyslog_conf_dir}..."
    /usr/bin/cp -f ${CURRENT_PATH}/rsyslog_karbor.conf ${rsyslog_conf_dir}
    CHECK_RESULT $? "Copy rsyslog_karbor.conf ${rsyslog_conf_dir} failed."

    log_info "Restart rsyslog..."
    service rsyslog restart
    if [ $? -ne 0 ];then
       log_info "Restart rsyslog failed, wait 10 seconds to retry..."
       sleep 10
       service rsyslog restart
       log_info "Result code of restarting rsyslog is:$?"
    fi
}

function install_script()
{
    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege  ${TOOL_PATH}
    log_info "Copy ${CURRENT_PATH}/cli_tools to ${TOOL_PATH}"

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/karbor.ver ${VERSION_PATH}
    setprivilege  ${VERSION_PATH}
    log_info "Copy karbor.ver to ${VERSION_PATH}"

    mkdir -p ${KARBOR_CONF_DIR}
    /usr/bin/cp -f ${CURRENT_PATH}/utils/* ${KARBOR_CONF_DIR}
    setprivilege  ${KARBOR_CONF_DIR}
    chmod 750 ${KARBOR_CONF_DIR}/karbor-SetState.sh
    rm -f /usr/bin/karbor-apiControl && ln -sf ${KARBOR_CONF_DIR}/karbor-SetState.sh /usr/bin/karbor-apiControl
    rm -f /usr/bin/karbor-protectionControl && ln -sf ${KARBOR_CONF_DIR}/karbor-SetState.sh /usr/bin/karbor-protectionControl
    rm -f /usr/bin/karbor-operationControl  && ln -sf ${KARBOR_CONF_DIR}/karbor-SetState.sh /usr/bin/karbor-operationControl
    log_info "Copy utils to ${KARBOR_CONF_DIR}"

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/karbor.sh ${INSPECT_SH_PATH}
    setprivilege  ${INSPECT_SH_PATH}
    chmod -R 750 ${INSPECT_SH_PATH}
    log_info "Copy karbor.sh to ${INSPECT_SH_PATH}"

    install_service_tool karbor-api
    install_service_tool karbor-protection
    install_service_tool karbor-operation
    log_info "Install Service tool finish."

}


function install_service_tool()
{
    local component=$1
    local tool_dir="/opt/huawei/dj/tools/services/"${component}
    local control=${component}Control
    mkdir -p ${tool_dir}
    /usr/bin/cp -f ${TOOL_PATH}/* ${tool_dir}
    chmod +x ${tool_dir}/*.sh
    echo "<root>
        <commands>
            <command name=\"start-service\">start.sh</command>
            <command name=\"stop-service\">stop.sh</command>
        </commands>
        <serviceControl>
            <control_script name=\"${component}\">${control}</control_script>
        </serviceControl>
    </root>
    " > ${tool_dir}/command_agent.xml
    echo "${control} -S RUN" > ${tool_dir}/start.sh
    echo "${control} -S STOP" > ${tool_dir}/stop.sh
    setprivilege  ${tool_dir}
}


function set_crontab_script()
{
    sed -i '/purge\.sh/d' /etc/crontab
    echo "0 6 * * * root /bin/bash /opt/huawei/dj/etc/karbor/purge.sh >/dev/null 2>&1" >> /etc/crontab
    if [ $(get_info.py node_index) -eq 1 ];then
        sed -i '/delete_expired_export_file\.sh/d' /etc/crontab
        echo "0 1-23/2 * * * root /bin/bash /opt/huawei/dj/etc/karbor/delete_expired_export_file.sh >/dev/null 2>&1" >> /etc/crontab
        sed -i '/inspect_long_running_baks\.sh/d' /etc/crontab
        echo "0 12 * * * root /bin/bash /opt/huawei/dj/etc/karbor/inspect_long_running_baks.sh >/dev/null 2>&1" >> /etc/crontab
    fi
}

function set_oma_script()
{
    local tool_dir=/opt/huawei/dj/tools
    local oma_dir=${CURRENT_PATH}/../../OMA
    mkdir -p ${tool_dir}
    /usr/bin/cp -rf ${oma_dir} ${tool_dir}
    setprivilege ${tool_dir}/OMA
    rm -rf /usr/bin/oma_state && ln -sf ${tool_dir}/OMA/oma_state.sh /usr/bin/oma_state
}


function set_sudoers_for_karbor()
{
    sed -i "/\/sync_certs.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/karbor/sync_certs.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/karbor-SetState.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/etc/karbor/karbor-SetState.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/usr\/bin\/docker ps -a/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker ps -a" >> /etc/sudoers.d/openstack
    sed -i "/docker exec karbor.*python/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec karborapi csbs_python /usr/lib/csbs_python/site-packages/kangaroo/config/check_config.py" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec karborprotection csbs_python /usr/lib/csbs_python/site-packages/kangaroo/config/check_config.py" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec karboroperation csbs_python /usr/lib/csbs_python/site-packages/kangaroo/config/check_config.py" >> /etc/sudoers.d/openstack
    sed -i "/docker exec .*kangaroo-manage*/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec -i karborapi kangaroo-manage disable_policies copy" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec -i karborapi kangaroo-manage disable_policies replication" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec -i karborapi kangaroo-manage get_region_name" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec -i karboroperation kangaroo-manage get_region_name" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec -i karborprotection kangaroo-manage get_region_name" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec karborprotection kangaroo-manage list_az -r true" >> /etc/sudoers.d/openstack
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/docker exec karborapi kangaroo-manage get_region_id" >> /etc/sudoers.d/openstack
    sed -i "/\/set_long_running_cfg.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/karbor/set_long_running_cfg.sh" >> /etc/sudoers.d/openstack
}

function set_operationtool_dir()
{
    local tools_dir=/opt/karbor/data
    local tools_dir_chg=/opt/karbor/
    mkdir -p ${tools_dir}
    chmod 750 ${tools_dir_chg}
    chmod 770 ${tools_dir}
    chown -hR root:openstack ${tools_dir_chg}
}

touch /etc/profile.d/serviceom_omm_agent.sh
deploy_uninstall_script
install_script
install_rsyslog
set_crontab_script
set_sudoers_for_karbor
set_oma_script
set_operationtool_dir
log_info "Finish docker image installation."
