#!/bin/bash
SCRIPT_FULL_PATH=`readlink -f $0`
CUR_DIR=`dirname ${SCRIPT_FULL_PATH}`
mkdir -p /var/log/install/
source ${CUR_DIR}/util.sh
mkdir -p /var/log/huawei/dj/services/system/karbor
mkdir -p /var/log/karbor
mkdir -p /var/log/install
mkdir -p /etc/huawei/dj/cfg
mkdir -p /opt/huawei/dj/inst/
mkdir -p /var/lib/karbor

setprivilege ${CUR_DIR}
find ${CUR_DIR} -type f -name "*.py" | xargs chmod 550
find ${CUR_DIR} -type f -name "*.sh" | xargs chmod 550

csbs_python -m pip install --no-deps --force-reinstall  ${CUR_DIR}/karbor*.whl
CHECK_RESULT $? "install karbor in docker"
csbs_python -m pip install --no-deps --force-reinstall  ${CUR_DIR}/kangaroo*.whl
CHECK_RESULT $? "install kangaroo in docker"
chmod 550 /etc/karbor/SetState.sh
ln -sf /etc/karbor/SetState.sh /usr/bin/karbor-apiControl
ln -sf /etc/karbor/SetState.sh /usr/bin/karbor-operationengineControl
ln -sf /etc/karbor/SetState.sh /usr/bin/karbor-protectionControl

rm -rf /usr/lib/csbs_python/site-packages/keystoneauth1/tests
rm -rf ${CUR_DIR}/comp/karbor/*.rpm

touch /var/run/syslogd.pid
touch /var/log/karbor/osprofiler-zipkin.log
touch /var/run/crond.pid

setprivilege /var/log/huawei
setprivilege /var/log/karbor
setprivilege /var/log/install
setprivilege /var/lib/karbor
setprivilege /var/run
setprivilege /usr/lib/csbs_python
setprivilege /opt/huawei
setprivilege /etc/huawei
setprivilege /etc/karbor
chmod 770 /etc/karbor
